/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.catacomb.be.Instantiator;
import org.catacomb.interlish.content.BooleanValue;
import org.catacomb.interlish.content.DoubleValue;
import org.catacomb.interlish.content.IntegerValue;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.reflect.ClassInstantiator;
import org.catacomb.interlish.reflect.Narrower;
import org.catacomb.interlish.resource.ImportContext;
import org.catacomb.interlish.resource.ResourceRole;
import org.catacomb.interlish.resource.Role;
import org.catacomb.interlish.service.ContentLoader;
import org.catacomb.interlish.service.ResourceAccess;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.interlish.structure.Attribute;
import org.catacomb.interlish.structure.AttributeAddableTo;
import org.catacomb.interlish.structure.Constructor;
import org.catacomb.report.E;

public class ReflectionConstructor
implements Constructor {
    ArrayList search = new ArrayList();
    int npkg = 0;
    String[] pkgs = new String[100];
    String wkpkg;
    ImportContext importContext;
    Instantiator instantiator = new ClassInstantiator();
    static ArrayList<String> paths = new ArrayList();

    public static void addPath(String s) {
        paths.add(s);
    }

    public ReflectionConstructor() {
        for (String s : paths) {
            this.addSearchPackage(s);
        }
    }

    public ReflectionConstructor(String path) {
        this();
        this.addSearchPackage(path);
    }

    public void setInstantiator(Instantiator inst) {
        this.instantiator = inst;
    }

    public void setImportContext(ImportContext ctx) {
        this.importContext = ctx;
    }

    public void addSearchPackage(String s) {
        this.wkpkg = s;
        this.pkgs[this.npkg++] = s;
    }

    @Override
    public void appendContent(Object obj, String s) {
        E.error(" - reflection instantiator doesn't do appendContent on " + obj);
    }

    public void checkAddPackage(Object oret) {
        String scl = oret.getClass().getName();
        if (scl.startsWith("java")) {
            return;
        }
        int ild = scl.lastIndexOf(".");
        String pkg = scl.substring(0, ild);
        if (!pkg.equals(this.wkpkg)) {
            boolean got = false;
            int i = 0;
            while (i < this.npkg) {
                if (this.pkgs[i].equals(pkg)) {
                    got = true;
                    break;
                }
                ++i;
            }
            if (!got) {
                this.pkgs[this.npkg++] = pkg;
            }
        }
    }

    @Override
    public Object newInstance(String scl) {
        int i;
        Object oret = null;
        Class<?> c = null;
        boolean fcnm = scl.startsWith("org.");
        if (scl.indexOf(".") > 0) {
            c = this.instantiator.forName(scl, fcnm);
        }
        if (c == null && !fcnm) {
            i = 0;
            while (i < this.npkg && c == null) {
                c = this.instantiator.forName(String.valueOf(this.pkgs[i]) + "." + scl);
                ++i;
            }
        }
        if (c == null) {
            E.error("cant instantiate (class not found): " + scl + "\n" + " instantiator: " + this.instantiator);
            E.reportCached();
            if (this.npkg == 0) {
                E.info("There are no search packages configured!");
            }
            i = 0;
            while (i < this.npkg) {
                E.info("tried package " + this.pkgs[i]);
                ++i;
            }
            if (scl.endsWith("ing")) {
                new Exception().printStackTrace();
            }
        } else {
            int imod = c.getModifiers();
            if (Modifier.isAbstract(imod)) {
                E.error("cant instantiatie " + c + ":  it is an abstract class");
            } else {
                try {
                    oret = c.newInstance();
                }
                catch (Exception e) {
                    E.error(" " + e + " instantiating " + c);
                    e.printStackTrace();
                }
            }
        }
        if (oret != null) {
            this.checkAddPackage(oret);
        }
        return oret;
    }

    @Override
    public Object getField(Object ob, String fnm) {
        Object ret = null;
        boolean hasField = false;
        Field[] flds = ob.getClass().getFields();
        int i = 0;
        while (i < flds.length) {
            if (flds[i].getName().equals(fnm)) {
                hasField = true;
                break;
            }
            ++i;
        }
        if (hasField) {
            try {
                Field f = ob.getClass().getField(fnm);
                Class<?> fcl = f.getType();
                ret = fcl.equals(String[].class) ? new String[]{} : (fcl.isArray() ? new ArrayList() : f.get(ob));
                if (ret == null) {
                    Class<?> cl = f.getType();
                    ret = cl.newInstance();
                }
            }
            catch (Exception e) {
                E.error("cant get field " + fnm + " on " + ob + " " + "excception= " + e);
            }
        }
        if (!hasField) {
            boolean cfr_ignored_0 = ob instanceof ArrayList;
        }
        return ret;
    }

    @Override
    public Object getChildObject(Object parent, String name, Attribute[] attain) {
        Attribute[] atta = attain;
        Object child = null;
        if (parent != null) {
            this.checkAddPackage(parent);
        }
        if (atta == null) {
            atta = new Attribute[]{};
        }
        String classname = null;
        int i = 0;
        while (i < atta.length) {
            Attribute att = atta[i];
            String attName = att.getName();
            String attValue = att.getValue();
            if (attName.equals("package")) {
                StringTokenizer stok = new StringTokenizer(attValue, ", ");
                while (stok.hasMoreTokens()) {
                    this.addSearchPackage(stok.nextToken());
                }
            } else if (attName.equals("archive-hash")) {
                if (this.importContext != null) {
                    child = this.importContext.getRelative(attValue);
                } else {
                    E.debugError("xmlreader found reference to archive file  but has no importContext to retrieve object");
                }
            } else if (attName.equals("class")) {
                classname = attValue;
            }
            ++i;
        }
        if (child == null && classname != null) {
            child = this.newInstance(classname);
        }
        if (child == null && parent != null) {
            child = this.getField(parent, name);
        }
        if (child == null && name.equals("Role")) {
            child = new ResourceRole();
        }
        if (child == null) {
            ContentLoader cl;
            if (ResourceAccess.hasContentLoader() && (cl = ResourceAccess.getContentLoader()).hasProviderOf(name)) {
                child = cl.getProviderOf(name);
                this.checkAddPackage(child);
            }
            if (child == null) {
                child = this.newInstance(name);
            }
        }
        if (child == null) {
            E.warning("ReflectionInstantiator failed to get field " + name + " on " + parent + " " + (parent != null ? parent.getClass().toString() : ""));
        }
        return child;
    }

    @Override
    public void applyAttributes(Object target, Attribute[] atta) {
        int i = 0;
        while (i < atta.length) {
            Attribute att = atta[i];
            this.setAttributeField(target, att.getName(), att.getValue());
            ++i;
        }
    }

    @Override
    public boolean setAttributeField(Object target, String name, String arg) {
        boolean bret = false;
        if (!(name.equals("class") || name.equals("package") || name.equals("provides") || name.equals("archive-hash"))) {
            bret = this.setField(target, name, arg);
        }
        return bret;
    }

    @Override
    public boolean setField(Object ob, String sfin, Object argin) {
        String sf = sfin;
        Object arg = argin;
        if (arg instanceof StringValue) {
            arg = ((StringValue)arg).getString();
        } else if (arg instanceof BooleanValue) {
            arg = new Boolean(((BooleanValue)arg).getBoolean());
        } else if (arg instanceof IntegerValue) {
            arg = new Integer(((IntegerValue)arg).getInteger());
        } else if (arg instanceof DoubleValue) {
            arg = new Double(((DoubleValue)arg).getDouble());
        }
        if (ob == null) {
            E.error("null parent for " + sf + " (" + arg + ")");
            return true;
        }
        if (arg == null) {
            return true;
        }
        if (arg.equals(ob)) {
            E.error("ReflectionInstantiator setField: the child is the same as the parent " + ob);
            return true;
        }
        int icolon = sf.indexOf(":");
        if (icolon >= 0) {
            sf = String.valueOf(sf.substring(0, icolon)) + "_" + sf.substring(icolon + 1, sf.length());
        }
        boolean ok = false;
        Class<?> c = ob.getClass();
        Field f = null;
        try {
            f = c.getField(sf);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (f == null) {
            if (ob instanceof ArrayList) {
                ((ArrayList)ob).add(arg);
                ok = true;
            } else if (arg instanceof String && ob instanceof AttributeAddableTo) {
                ((AttributeAddableTo)ob).addAttribute(sf, (String)arg);
                ok = true;
            } else if (ob instanceof AddableTo && this.nonPrimitive(arg)) {
                ((AddableTo)ob).add(arg);
                ok = true;
            } else if (arg instanceof Role) {
                ok = true;
            } else {
                E.linkToWarning("no such field " + sf, ob);
                E.reportCached();
                ok = false;
            }
        } else {
            if (arg instanceof ArrayList && ((ArrayList)arg).size() == 1 && !f.getType().isArray()) {
                for (Object sub : (ArrayList)arg) {
                    arg = sub;
                }
            }
            try {
                Class<?> ftyp = f.getType();
                if (ftyp == String.class && arg instanceof String) {
                    f.set(ob, arg);
                } else if (ftyp == Double.TYPE && arg instanceof String) {
                    Double d = new Double((String)arg);
                    f.set(ob, d);
                } else if (ftyp == Double.TYPE && arg instanceof Double) {
                    f.set(ob, arg);
                } else if (ftyp == Boolean.TYPE && arg instanceof Boolean) {
                    f.set(ob, arg);
                } else if (ftyp == Integer.TYPE && arg instanceof Integer) {
                    f.set(ob, arg);
                } else if (f.getType().isArray() && arg instanceof ArrayList) {
                    this.setArrayField(ob, f, (ArrayList)arg);
                } else {
                    Object onarg = Narrower.narrow(ftyp.getName(), arg);
                    if (onarg != null) {
                        f.set(ob, onarg);
                    } else {
                        f.set(ob, arg);
                    }
                }
                ok = true;
            }
            catch (Exception e) {
                ok = false;
                E.error(" cant set field " + sf + " in " + ob + " from typed " + arg.getClass().getName() + " value " + arg + " " + e);
            }
        }
        return ok;
    }

    public void setArrayField(Object obj, Field fld, ArrayList vals) {
        try {
            int nv = vals.size();
            Class<?> acls = fld.getType();
            Class<?> ccls = acls.getComponentType();
            Object avals = Array.newInstance(ccls, nv);
            int i = 0;
            while (i < nv) {
                Array.set(avals, i, vals.get(i));
                ++i;
            }
            fld.set(obj, avals);
        }
        catch (Exception ex) {
            E.error(" - cant setaray field " + fld + " " + vals);
        }
    }

    private boolean nonPrimitive(Object arg) {
        boolean ret = true;
        if (arg instanceof String || arg instanceof Integer || arg instanceof Double) {
            ret = false;
        }
        return ret;
    }

    @Override
    public void setIntFromStatic(Object ret, String id, String sv) {
        String svu = sv.toUpperCase();
        Object obj = this.getField(ret, svu);
        if (obj instanceof Integer) {
            this.setField(ret, id, obj);
        } else {
            E.error("need an Integer, not  " + obj);
        }
    }
}

