/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.Collection;
import java.util.HashMap;
import org.catacomb.interlish.structure.Element;
import org.catacomb.interlish.structure.ElementFactory;
import org.catacomb.interlish.structure.ElementWriter;
import org.catacomb.interlish.structure.Elementizer;
import org.catacomb.interlish.structure.Named;
import org.catacomb.numeric.data.DataItem;
import org.catacomb.numeric.data.DataSetArray;
import org.catacomb.numeric.data.FloatScalar;
import org.catacomb.numeric.data.FloatVector;
import org.catacomb.numeric.data.VectorSet;
import org.catacomb.report.E;

public class NumDataSet
extends DataItem
implements ElementWriter {
    HashMap<String, DataItem> itemHM = new HashMap();

    public NumDataSet() {
        this("error");
    }

    public NumDataSet(String s) {
        super(s);
    }

    public Collection<String> getNames() {
        return this.itemHM.keySet();
    }

    public Collection<DataItem> getValues() {
        return this.itemHM.values();
    }

    public int size() {
        return this.itemHM.keySet().size();
    }

    public String toString() {
        return "NumDataSet:" + this.name;
    }

    public boolean matches(NumDataSet ds) {
        return this.name.equals(ds.getName());
    }

    public DataItem get(String sit) {
        DataItem ret = null;
        if (this.itemHM.containsKey(sit)) {
            ret = this.itemHM.get(sit);
        } else {
            E.error("Data Set no such item " + sit);
        }
        return ret;
    }

    public void add(Object obj) {
        if (obj instanceof Named && obj instanceof DataItem) {
            this.itemHM.put(((Named)obj).getName(), (DataItem)obj);
        } else {
            E.error("NumDataSet cant add " + obj);
        }
    }

    public void addScalar(String lname, String value) {
        this.addScalar(new FloatScalar(lname, value));
    }

    public void addScalar(FloatScalar fs) {
        this.itemHM.put(fs.getName(), fs);
    }

    public void addVector(FloatVector fv) {
        this.itemHM.put(fv.getName(), fv);
    }

    public void addVectorSet(VectorSet vs) {
        FloatVector[] fva = vs.getVectors();
        int i = 0;
        while (i < fva.length) {
            this.addVector(fva[i]);
            ++i;
        }
    }

    public void addVectorOrScalar(String nm, String stxt) {
        FloatVector fv = new FloatVector(nm, stxt);
        if (fv.length() > 1) {
            this.addVector(fv);
        } else {
            this.addScalar(new FloatScalar(fv));
        }
    }

    public void addDataSet(NumDataSet ds) {
        String nm = ds.getName();
        if (this.itemHM.containsKey(nm)) {
            DataItem obj = this.itemHM.get(nm);
            if (obj instanceof DataSetArray) {
                ((DataSetArray)obj).add(ds);
            } else if (obj instanceof NumDataSet) {
                DataSetArray arl = new DataSetArray();
                arl.setName(nm);
                arl.add((NumDataSet)obj);
                arl.add(ds);
                this.itemHM.remove(nm);
                this.itemHM.put(nm, arl);
            } else {
                E.error("cant add data set " + ds + " to " + this + " : mismatched types");
            }
        } else {
            this.itemHM.put(nm, ds);
        }
    }

    @Override
    public Element makeElement(ElementFactory efac, Elementizer eltz) {
        Element elt = efac.makeElement(this.name != null ? this.name : "NumDataSet");
        for (String sk : this.itemHM.keySet()) {
            DataItem obj = this.itemHM.get(sk);
            if (obj instanceof NumDataSet) {
                efac.addElement(elt, ((NumDataSet)obj).makeElement(efac, eltz));
                continue;
            }
            if (obj instanceof FloatScalar) {
                FloatScalar fs = (FloatScalar)obj;
                efac.addAttribute(elt, fs.getName(), fs.getValue());
                continue;
            }
            if (obj instanceof FloatVector) {
                FloatVector fv = (FloatVector)obj;
                efac.addElement(elt, efac.makeElement(fv.getName(), fv.getStringValue()));
                continue;
            }
            if (obj instanceof DataSetArray) {
                DataSetArray dsa = (DataSetArray)obj;
                NumDataSet[] dsv = dsa.getDataSets();
                int i = 0;
                while (i < dsv.length) {
                    efac.addElement(elt, dsv[i].makeElement(efac, eltz));
                    ++i;
                }
                continue;
            }
            E.error("Data set element making cant handle " + obj);
        }
        return elt;
    }

    @Override
    public DataItem getMarked() {
        return this.copyMarked();
    }

    public NumDataSet copyMarked() {
        NumDataSet ret = new NumDataSet(this.getName());
        for (DataItem dit : this.itemHM.values()) {
            if (!dit.isMarked()) continue;
            ret.add(dit.getMarked());
        }
        return ret;
    }
}

