/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import org.catacomb.interlish.structure.Attribute;
import org.catacomb.interlish.structure.Element;
import org.catacomb.interlish.structure.Factory;
import org.catacomb.numeric.data.FloatRow;
import org.catacomb.numeric.data.NumDataSet;
import org.catacomb.numeric.data.VectorSet;
import org.catacomb.report.E;

public class NumDataSetFactory
implements Factory {
    public String makes;

    @Override
    public Object make(String s) {
        NumDataSet dset = new NumDataSet(s);
        return dset;
    }

    private NumDataSet makeDataSet(Element elt) {
        NumDataSet ds = new NumDataSet(elt.getName());
        this.populate(ds, elt);
        return ds;
    }

    @Override
    public void populate(Object obj, Element popelt) {
        NumDataSet ds = (NumDataSet)obj;
        this.populate(ds, popelt);
    }

    private void populate(NumDataSet ds, Element popelt) {
        Attribute[] atta = popelt.getAttributeArray();
        int i = 0;
        while (i < atta.length) {
            Attribute att = atta[i];
            if (att.getName().equals("name")) {
                ds.setName(att.getValue());
            } else {
                ds.addVectorOrScalar(att.getName(), att.getValue());
            }
            ++i;
        }
        Element[] elta = popelt.getElementArray();
        int i2 = 0;
        while (i2 < elta.length) {
            Element elt = elta[i2];
            if (elt.getName().equals("VectorSet")) {
                VectorSet vset = this.makeVectorSet(elt);
                ds.addVectorSet(vset);
            } else if (elt.hasElements() || elt.hasAttributes()) {
                NumDataSet cds = this.makeDataSet(elt);
                ds.addDataSet(cds);
            } else {
                ds.addVectorOrScalar(elt.getName(), elt.getText());
            }
            ++i2;
        }
    }

    private VectorSet makeVectorSet(Element popelt) {
        VectorSet vset = new VectorSet();
        vset.setNames(popelt.getAttribute("names"));
        Element[] elta = popelt.getElementArray();
        int i = 0;
        while (i < elta.length) {
            Element elt = elta[i];
            if (elt.getName().equals("row")) {
                vset.addRow(new FloatRow(elt.getText()));
            } else {
                E.error("only row elements allowed in a vector set, not " + elt.getName());
            }
            ++i;
        }
        return vset;
    }
}

