/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.calc;

import org.catacomb.numeric.difnet.StateNode;
import org.catacomb.numeric.difnet.Stimulus;
import org.catacomb.numeric.difnet.calc.NetMapLink;

public final class NetMapNode {
    int peerIndex;
    int index;
    boolean fixed;
    boolean locallyFixed;
    double value;
    double flux;
    double capacitance;
    double appliedValue;
    double appliedFlux;
    double appliedDrive;
    double appliedConductance;
    NetMapLink[] upLink;
    NetMapLink[] downLink;
    boolean mark;
    double diag;
    double rhs;

    void readState(StateNode dnNode, double time) {
        this.value = dnNode.getValue(null);
        this.appliedValue = dnNode.getAppliedValue(null);
        this.locallyFixed = false;
        this.appliedFlux = 0.0;
        this.diag = 0.0;
        this.rhs = 0.0;
        Stimulus stim = dnNode.getStimulus();
        if (stim != null) {
            int typ = stim.getType();
            double v = stim.getValue(time);
            if (typ == 1) {
                this.value = this.appliedValue = v;
                this.locallyFixed = true;
                this.diag = 1.0;
                this.rhs = 0.0;
            } else if (typ == 2) {
                this.appliedFlux = v;
            }
        }
    }

    void writeState(StateNode dnNode) {
        dnNode.setValue(null, this.value);
        if (this.fixed || this.locallyFixed) {
            dnNode.setFlux(null, this.flux);
        }
    }

    boolean isFree() {
        return !this.fixed && !this.locallyFixed;
    }
}

