/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.calc;

import org.catacomb.numeric.difnet.NetState;
import org.catacomb.numeric.difnet.NetStructure;
import org.catacomb.numeric.difnet.StateLink;
import org.catacomb.numeric.difnet.StateNode;
import org.catacomb.numeric.difnet.StructureLink;
import org.catacomb.numeric.difnet.StructureNode;
import org.catacomb.numeric.difnet.calc.NetMapLink;
import org.catacomb.numeric.difnet.calc.NetMapNode;

public final class OrderedNetMap {
    NetMapNode[] node;
    NetMapLink[] link;
    boolean acyclic = true;
    private boolean useIntrinsics;

    OrderedNetMap(NetStructure dn) {
        StructureNode[] difnetNode = dn.getNodes();
        StructureLink[] difnetLink = dn.getLinks();
        int nnode = difnetNode.length;
        int nlink = difnetLink.length;
        int i = 0;
        while (i < nnode) {
            difnetNode[i].setWork(i);
            ++i;
        }
        NetMapNode[] wkNode = new NetMapNode[nnode];
        NetMapLink[] wkLink = new NetMapLink[nlink];
        int i2 = 0;
        while (i2 < nnode) {
            wkNode[i2] = new NetMapNode();
            wkNode[i2].peerIndex = i2;
            wkNode[i2].fixed = difnetNode[i2].hasFixedValue(null);
            ++i2;
        }
        i2 = 0;
        while (i2 < nlink) {
            wkLink[i2] = new NetMapLink();
            wkLink[i2].peerIndex = i2;
            int iwka = difnetLink[i2].getNodeA().getWork();
            wkLink[i2].nodeA = wkNode[iwka];
            int iwkb = difnetLink[i2].getNodeB().getWork();
            wkLink[i2].nodeB = wkNode[iwkb];
            ++i2;
        }
        NetMapLink[][] linksPerNode = new NetMapLink[nnode][6];
        linksPerNode[0] = new NetMapLink[nnode];
        int[] nlinksPerNode = new int[nnode];
        int i3 = 0;
        while (i3 < nlink) {
            if (!wkLink[i3].nodeA.fixed) {
                int ia;
                int n = ia = wkLink[i3].nodeA.peerIndex;
                int n2 = nlinksPerNode[n];
                nlinksPerNode[n] = n2 + 1;
                linksPerNode[ia][n2] = wkLink[i3];
            }
            if (!wkLink[i3].nodeB.fixed) {
                int ib;
                int n = ib = wkLink[i3].nodeB.peerIndex;
                int n3 = nlinksPerNode[n];
                nlinksPerNode[n] = n3 + 1;
                linksPerNode[ib][n3] = wkLink[i3];
            }
            ++i3;
        }
        this.node = new NetMapNode[nnode];
        i3 = 0;
        while (i3 < nnode) {
            wkNode[i3].mark = false;
            ++i3;
        }
        i3 = 0;
        while (i3 < nlink) {
            wkLink[i3].mark = false;
            wkLink[i3].flip = false;
            ++i3;
        }
        int[] iin = new int[1];
        int i4 = 0;
        while (i4 < nnode) {
            if (wkNode[i4].fixed && !wkNode[i4].mark) {
                int n = iin[0];
                iin[0] = n + 1;
                this.node[n] = wkNode[i4];
                wkNode[i4].mark = true;
            }
            ++i4;
        }
        int ntree = 0;
        int i5 = 0;
        while (i5 < nnode) {
            if (!wkNode[i5].mark) {
                ++ntree;
                this.recindex(this.node, iin, linksPerNode, wkNode[i5]);
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < nnode) {
            this.node[i5].upLink = this.tidyLinkArray(this.node[i5].upLink);
            this.node[i5].downLink = this.tidyLinkArray(this.node[i5].downLink);
            ++i5;
        }
        i5 = 0;
        while (i5 < nnode) {
            this.node[i5].index = i5;
            ++i5;
        }
        this.link = wkLink;
    }

    public boolean getUseIntrinsics() {
        return this.useIntrinsics;
    }

    public void Sp(String s) {
        System.out.println(s);
    }

    public void print() {
        this.Sp("ordered net map with " + this.node.length + " nodes, structure indexes in brackets ");
        int i = 0;
        while (i < this.node.length) {
            NetMapNode nmn = this.node[i];
            this.Sp("node " + i + "(" + nmn.peerIndex + "), ndownlinks=" + nmn.downLink.length + ", nuplink=" + nmn.upLink.length);
            if (!nmn.isFree()) {
                this.Sp("fixed at " + nmn.value);
            }
            int j = 0;
            while (j < nmn.downLink.length) {
                this.printLink("down ", nmn.downLink[j], j);
                ++j;
            }
            j = 0;
            while (j < nmn.upLink.length) {
                this.printLink("  up ", nmn.upLink[j], j);
                ++j;
            }
            ++i;
        }
    }

    public void printLink(String dir, NetMapLink lk, int lki) {
        this.Sp(String.valueOf(dir) + lki + "(" + lk.peerIndex + "),  nodeA=" + lk.nodeA.index + "(" + lk.nodeA.peerIndex + "), nodeB=" + lk.nodeB.index + "(" + lk.nodeB.peerIndex + "), g=" + lk.conductance + ", c=" + lk.capacitance);
    }

    NetMapNode[] getNodes() {
        return this.node;
    }

    NetMapLink[] tidyLinkArray(NetMapLink[] cain) {
        NetMapLink[] ca = cain;
        if (ca == null) {
            return new NetMapLink[0];
        }
        int n = 0;
        while (n < ca.length && ca[n] != null) {
            ++n;
        }
        if (n < ca.length) {
            NetMapLink[] cb = ca;
            ca = new NetMapLink[n];
            int i = 0;
            while (i < n) {
                ca[i] = cb[i];
                ++i;
            }
        }
        return ca;
    }

    private NetMapLink[] addLink(NetMapLink[] cain, NetMapLink c) {
        NetMapLink[] ca = cain;
        int n = 0;
        if (ca == null) {
            ca = new NetMapLink[3];
        }
        while (n < ca.length && ca[n] != null) {
            ++n;
        }
        if (n == ca.length) {
            ca = this.extendNetMapLinkArray(ca);
        }
        ca[n] = c;
        return ca;
    }

    private NetMapLink[] extendNetMapLinkArray(NetMapLink[] ca) {
        int n = ca.length;
        NetMapLink[] cb = new NetMapLink[2 * n];
        int i = 0;
        while (i < n) {
            cb[i] = ca[i];
            ++i;
        }
        return cb;
    }

    private void recindex(NetMapNode[] nodeArray, int[] inxt, NetMapLink[][] linksPerNode, NetMapNode currentNode) {
        NetMapLink h;
        currentNode.mark = true;
        int n = inxt[0];
        inxt[0] = n + 1;
        nodeArray[n] = currentNode;
        NetMapLink[] nbrs = linksPerNode[currentNode.peerIndex];
        int i = 0;
        while (i < nbrs.length && nbrs[i] != null) {
            h = nbrs[i];
            if (!h.mark && (h.nodeB.fixed || h.nodeA.fixed)) {
                if (h.nodeB.fixed) {
                    h.reverseEnds();
                }
                h.nodeA.upLink = this.addLink(h.nodeA.upLink, h);
                h.nodeB.downLink = this.addLink(h.nodeB.downLink, h);
                h.mark = true;
            }
            ++i;
        }
        i = 0;
        while (i < nbrs.length && nbrs[i] != null) {
            h = nbrs[i];
            if (!h.mark) {
                h.mark = true;
                if (h.nodeA != currentNode) {
                    h.reverseEnds();
                }
                h.nodeA.upLink = this.addLink(h.nodeA.upLink, h);
                h.nodeB.downLink = this.addLink(h.nodeB.downLink, h);
                if (h.nodeB.mark) {
                    System.out.println("WARNING found link which breaks acyclic prop? from peers " + h.nodeA.peerIndex + " to " + h.nodeB.peerIndex);
                    this.acyclic = false;
                } else {
                    this.recindex(nodeArray, inxt, linksPerNode, h.nodeB);
                }
            }
            ++i;
        }
    }

    boolean isAcyclic() {
        return this.acyclic;
    }

    void readState(NetState dn) {
        this.useIntrinsics = dn.useIntrinsics();
        StateNode[] difnetNode = dn.getNodes();
        int i = 0;
        while (i < this.node.length) {
            this.node[i].readState(difnetNode[this.node[i].peerIndex], dn.getTime());
            ++i;
        }
        StateLink[] difnetLink = dn.getLinks();
        int i2 = 0;
        while (i2 < this.link.length) {
            this.link[i2].readState(difnetLink[this.link[i2].peerIndex]);
            ++i2;
        }
    }

    void writeState(NetState difnet) {
        StateNode[] difnetNode = difnet.getNodes();
        int i = 0;
        while (i < this.node.length) {
            this.node[i].writeState(difnetNode[this.node[i].peerIndex]);
            ++i;
        }
    }
}

