/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.math;

public abstract class DiagonalBlockMatrix {
    private static final double abs(double d) {
        return Math.abs(d);
    }

    private static final double max(double a, double b) {
        return a > b ? a : b;
    }

    public static void main(String[] argv) {
        DiagonalBlockMatrix.dbmTest();
    }

    public static void Sp(String s) {
        System.out.println(s);
    }

    public static final void dbmTest() {
        int nv = 8;
        int nm = 99;
        int ne = 1;
        double[][][] a = new double[nm][3 * nv + ne + 1][nv + 4];
        double[][][] b = new double[nm][3 * nv + ne + 1][nv + 4];
        int[] nrpb = new int[nm];
        int ii = 1234;
        int i = 0;
        while (i < nm) {
            int j = 0;
            while (j < nv + 4) {
                int k = 0;
                while (k < 3 * nv + ne + 1) {
                    double ddd;
                    ii *= 7;
                    a[i][k][j] = ddd = 0.00345 * (double)(ii %= 14567);
                    b[i][k][j] = a[i][k][j];
                    ++k;
                }
                ++j;
            }
            nrpb[i] = nv;
            ++i;
        }
        nrpb[0] = nrpb[0] - 2;
        int n = nm - 1;
        nrpb[n] = nrpb[n] + 3;
        long ttt = System.currentTimeMillis();
        double[] corr = DiagonalBlockMatrix.dbmSolve(nv, nm, ne, nrpb, a);
        ttt = System.currentTimeMillis() - ttt;
        double maxdev = 0.0;
        int i2 = 0;
        while (i2 < nm) {
            int k0 = i2 - 1;
            if (k0 < 0) {
                k0 = 0;
            }
            int kk = 3;
            if (i2 <= 0 || i2 == nm - 1) {
                kk = 2;
            }
            int j = 0;
            while (j < nrpb[i2]) {
                double v = 0.0;
                int k = 0;
                while (k < kk * nv) {
                    v += b[i2][k][j] * corr[nv * k0 + k];
                    ++k;
                }
                k = 0;
                while (k < ne) {
                    v += b[i2][kk * nv + k][j] * corr[nv * nm + k];
                    ++k;
                }
                double dev = v - b[i2][kk * nv + ne][j];
                if ((dev = Math.abs(dev)) > maxdev) {
                    maxdev = dev;
                }
                if (dev > 0.001) {
                    DiagonalBlockMatrix.Sp("  " + i2 + " " + j + " " + v + " " + b[i2][kk * nv + ne][j]);
                }
                ++j;
            }
            ++i2;
        }
        if (maxdev > 0.01) {
            int nl = corr.length;
            DiagonalBlockMatrix.Sp("corr elts " + corr[nl - 1] + " " + corr[nl - 2]);
        }
        DiagonalBlockMatrix.Sp("max deviation " + maxdev);
        DiagonalBlockMatrix.Sp(" calc time " + ttt);
    }

    public static final double[] dbmSolve(int nm, int nv, int ne, int[] nrpb, double[][][] a) {
        double[][] b;
        int[] nnz = new int[nm];
        double[] corr = new double[nv * nm + ne];
        int ncollx = 3 * nv + ne + 1;
        int[] nelim = new int[nm];
        nelim[0] = 0;
        nelim[1] = nrpb[0];
        int k = 2;
        while (k < nm) {
            nelim[k] = nelim[k - 1] + nrpb[k - 1] - nv;
            ++k;
        }
        k = 0;
        while (k < nm) {
            int ncoll = ncollx;
            if (k == 0 || k == nm - 1) {
                ncoll -= nv;
            }
            b = a[k];
            int nel = nelim[k];
            if (nel > 0) {
                double[][] s = a[k - 1];
                int novlp = nnz[k - 1] - ne - 1;
                int nu = nrpb[k - 1] - nel;
                int ns = nnz[k - 1];
                int ic = 0;
                while (ic < nel) {
                    int ir = 0;
                    while (ir < nrpb[k]) {
                        double f = b[ic][ir];
                        int j = 0;
                        while (j < novlp) {
                            double[] dArray = b[j + nel];
                            int n = ir;
                            dArray[n] = dArray[n] - f * s[j][nu + ic];
                            ++j;
                        }
                        j = 1;
                        while (j < ne + 2) {
                            double[] dArray = b[ncoll - j];
                            int n = ir;
                            dArray[n] = dArray[n] - f * s[ns - j][nu + ic];
                            ++j;
                        }
                        ++ir;
                    }
                    ++ic;
                }
            }
            int ic = 0;
            while (ic < ncoll - nel) {
                b[ic] = b[nel + ic];
                ++ic;
            }
            DiagonalBlockMatrix.diag(nrpb[k], ncoll - nel, a[k], k);
            nnz[k] = ncoll - nelim[k] - nrpb[k];
            ic = 0;
            while (ic < nnz[k]) {
                b[ic] = b[ic + nrpb[k]];
                ++ic;
            }
            ic = nnz[k];
            while (ic < ncoll) {
                b[ic] = null;
                ++ic;
            }
            ++k;
        }
        if (nnz[nm - 1] != 1) {
            DiagonalBlockMatrix.Sp("solve error " + nnz[nm]);
        }
        int l = nv * nm + ne;
        int k2 = nm - 1;
        while (k2 >= 0) {
            b = a[k2];
            int nz = nnz[k2];
            int nr = nrpb[k2];
            int i = 1;
            while (i <= nr) {
                double c = b[nz - 1][nr - i];
                int j = 1;
                while (j <= ne && j < nz) {
                    c -= b[nz - j - 1][nr - i] * corr[nv * nm + ne - j];
                    ++j;
                }
                j = 0;
                while (j < nz - 1 - ne) {
                    c -= b[j][nr - i] * corr[l + j];
                    ++j;
                }
                corr[l - i] = c;
                ++i;
            }
            l -= nrpb[k2];
            --k2;
        }
        return corr;
    }

    public static final int diag(int nr, int nc, double[][] s, int block) {
        int ic;
        double[] rn = new double[nr];
        double[] pivr = new double[nc];
        int ir = 0;
        while (ir < nr) {
            rn[ir] = 0.0;
            ic = 0;
            while (ic < nc - 1) {
                rn[ir] = DiagonalBlockMatrix.max(DiagonalBlockMatrix.abs(s[ic][ir]), rn[ir]);
                ++ic;
            }
            if (rn[ir] <= 0.0) {
                DiagonalBlockMatrix.Sp("row sum 0 in block " + block + "  row " + ir);
                return -1;
            }
            rn[ir] = 1.0 / rn[ir];
            ++ir;
        }
        ir = 0;
        while (ir < nr) {
            int k = ir;
            double mx = DiagonalBlockMatrix.abs(s[ir][ir] * rn[ir]);
            int l = ir + 1;
            while (l < nr) {
                double v = DiagonalBlockMatrix.abs(rn[l] * s[ir][l]);
                if (v > mx) {
                    mx = v;
                    k = l;
                }
                ++l;
            }
            if (s[ir][k] == 0.0) {
                DiagonalBlockMatrix.Sp("no pivot in block " + block + " for row " + ir);
                return -1;
            }
            double f = 1.0 / s[ir][k];
            int i = 0;
            while (i < nc) {
                pivr[i] = s[i][k] * f;
                s[i][k] = s[i][ir];
                ++i;
            }
            rn[k] = rn[ir];
            i = ir + 1;
            while (i < nr) {
                double g = s[ir][i];
                int j = ir;
                while (j < nc) {
                    double[] dArray = s[j];
                    int n = i;
                    dArray[n] = dArray[n] - g * pivr[j];
                    ++j;
                }
                ++i;
            }
            int j = ir + 1;
            while (j < nc) {
                s[j][ir] = pivr[j];
                ++j;
            }
            ++ir;
        }
        ir = nr - 2;
        while (ir >= 0) {
            ic = ir + 1;
            while (ic < nr) {
                double g = s[ic][ir];
                int j = nr;
                while (j < nc) {
                    double[] dArray = s[j];
                    int n = ir;
                    dArray[n] = dArray[n] - g * s[j][ic];
                    ++j;
                }
                ++ic;
            }
            --ir;
        }
        return 0;
    }
}

