/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.mesh;

import org.catacomb.numeric.mesh.MeshPoint;

public class DifMeshPoint
implements MeshPoint {
    double xpos;
    double ypos;
    double zpos;
    double radius;
    int idIndex = -1;
    int nnbr;
    DifMeshPoint[] nbrs = new DifMeshPoint[4];
    int iwork;

    public DifMeshPoint() {
    }

    public DifMeshPoint(double x, double y, double z, double r, int idx) {
        this();
        this.xpos = x;
        this.ypos = y;
        this.zpos = z;
        this.radius = r;
        this.idIndex = idx;
    }

    @Override
    public int getNeighborCount() {
        return this.nnbr;
    }

    @Override
    public MeshPoint[] getNeighbors() {
        return this.nbrs;
    }

    @Override
    public void addNeighbor(MeshPoint nnn) {
        this.nbrs[this.nnbr] = (DifMeshPoint)nnn;
        ++this.nnbr;
    }

    @Override
    public void replaceNeighbor(MeshPoint oldNode, MeshPoint newNode) {
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbrs[i] == oldNode) {
                this.nbrs[i] = (DifMeshPoint)newNode;
            }
            ++i;
        }
    }

    @Override
    public void disconnect() {
        this.nnbr = 0;
    }

    @Override
    public void setWork(int i) {
        this.iwork = i;
    }

    @Override
    public int getWork() {
        return this.iwork;
    }

    @Override
    public double getX() {
        return this.xpos;
    }

    @Override
    public double getY() {
        return this.ypos;
    }

    @Override
    public double getZ() {
        return this.zpos;
    }

    @Override
    public double getR() {
        return this.radius;
    }

    @Override
    public int getIDIndex() {
        return this.idIndex;
    }

    @Override
    public void setX(double x) {
        this.xpos = x;
    }

    @Override
    public void setY(double y) {
        this.ypos = y;
    }

    @Override
    public void setZ(double z) {
        this.zpos = z;
    }

    @Override
    public void setR(double r) {
        this.radius = r;
    }

    @Override
    public MeshPoint newPoint() {
        return new DifMeshPoint();
    }

    @Override
    public MeshPoint[] newPointArray(int n) {
        return new DifMeshPoint[n];
    }
}

