/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.mesh;

import java.util.ArrayList;
import org.catacomb.numeric.mesh.MeshPoint;

public abstract class Discretizer {
    public static MeshPoint[] discretize(MeshPoint[] pt, double disqrtr, int maxnpt) {
        int np = pt.length;
        double[][][] subdiv = new double[np][6][];
        int i = 0;
        while (i < np) {
            pt[i].setWork(i);
            ++i;
        }
        int nnp = 0;
        int i2 = 0;
        while (i2 < np) {
            MeshPoint cpa = pt[i2];
            int nnbr = cpa.getNeighborCount();
            MeshPoint[] anbrs = cpa.getNeighbors();
            int j = 0;
            while (j < nnbr) {
                MeshPoint cpb = anbrs[j];
                if (cpa.getWork() < cpb.getWork()) {
                    subdiv[i2][j] = Discretizer.getSubdivision(cpa, cpb, disqrtr);
                    nnp += subdiv[i2][j].length;
                }
                ++j;
            }
            ++i2;
        }
        if (np + nnp > maxnpt) {
            Discretizer.Sp("WARNING - not discretizing: needs too many points (" + np + nnp + ")");
            return null;
        }
        MeshPoint[] pr = new MeshPoint[np + nnp];
        int i3 = 0;
        while (i3 < np) {
            pr[i3] = pt[i3];
            ++i3;
        }
        int nxp = np;
        int i4 = 0;
        while (i4 < np) {
            MeshPoint cpa = pt[i4];
            int nnbr = cpa.getNeighborCount();
            MeshPoint[] anbrs = cpa.getNeighbors();
            int j = 0;
            while (j < nnbr) {
                double[] div = subdiv[i4][j];
                if (div != null && div.length > 0) {
                    MeshPoint cpb = anbrs[j];
                    MeshPoint clast = null;
                    int id = 0;
                    while (id < div.length) {
                        MeshPoint cp = cpa.newPoint();
                        Discretizer.locateBetween(cpa, cpb, div[id], cp);
                        pr[nxp++] = cp;
                        if (id == 0) {
                            cpa.replaceNeighbor(cpb, cp);
                            cp.addNeighbor(cpa);
                        }
                        if (id == div.length - 1) {
                            cpb.replaceNeighbor(cpa, cp);
                            cp.addNeighbor(cpb);
                        }
                        if (clast != null) {
                            cp.addNeighbor(clast);
                            clast.addNeighbor(cp);
                        }
                        clast = cp;
                        ++id;
                    }
                }
                ++j;
            }
            ++i4;
        }
        return pr;
    }

    public static void locateBetween(MeshPoint cpa, MeshPoint cpb, double f, MeshPoint cpn) {
        double wf = 1.0 - f;
        cpn.setX(f * cpb.getX() + wf * cpa.getX());
        cpn.setY(f * cpb.getY() + wf * cpa.getY());
        cpn.setZ(f * cpb.getZ() + wf * cpa.getZ());
        cpn.setR(f * cpb.getR() + wf * cpa.getR());
    }

    public static double distanceBetween(MeshPoint cp, MeshPoint cq) {
        double dx = cp.getX() - cq.getX();
        double dy = cp.getY() - cq.getY();
        double dz = cp.getZ() - cq.getZ();
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return d;
    }

    public static void movePerp(MeshPoint ca, MeshPoint cb, double dperp, MeshPoint cm) {
        double dx = cb.getX() - ca.getX();
        double dy = cb.getY() - ca.getY();
        double f = Math.sqrt(dx * dx + dy * dy);
        double x = cm.getX();
        double y = cm.getY();
        cm.setX(x += dperp * (dy /= f));
        cm.setY(y -= dperp * (dx /= f));
    }

    public static MeshPoint[] merge(MeshPoint[] pt, double maxdr, double maxlen, double tol) {
        int i = 0;
        while (i < pt.length) {
            pt[i].setWork(2);
            ++i;
        }
        MeshPoint p0 = pt[0];
        Discretizer.recMerge(p0, maxdr, maxlen, tol);
        int nl = 0;
        int i2 = 0;
        while (i2 < pt.length) {
            if (pt[i2].getWork() > 0) {
                ++nl;
            }
            ++i2;
        }
        MeshPoint[] pr = p0.newPointArray(nl);
        nl = 0;
        int i3 = 0;
        while (i3 < pt.length) {
            if (pt[i3].getWork() > 0) {
                pr[nl++] = pt[i3];
            }
            ++i3;
        }
        return pr;
    }

    public static void recMerge(MeshPoint cp, double maxdr, double maxlen, double tol) {
        cp.setWork(1);
        int nnbr = cp.getNeighborCount();
        MeshPoint[] anbrs = cp.getNeighbors();
        int j = 0;
        while (j < nnbr) {
            MeshPoint cq = anbrs[j];
            double rp = cp.getR();
            double rq = cq.getR();
            if (cq.getWork() == 2 && cq.getNeighborCount() == 2 && Math.abs((rq - rp) / (rq + rp)) < 0.5 * maxdr && Discretizer.distanceBetween(cp, cq) < maxlen) {
                boolean cor;
                double dl;
                MeshPoint cprev = cp;
                ArrayList<MeshPoint> vpt = new ArrayList<MeshPoint>();
                double ltot = 0.0;
                double ldtot = 0.0;
                while (cq.getNeighborCount() == 2 && Discretizer.distanceBetween(cprev, cq) < maxlen && Math.abs((rq - rp) / (rq + rp)) < 0.5 * maxdr) {
                    vpt.add(cq);
                    dl = Discretizer.distanceBetween(cprev, cq);
                    ltot += dl;
                    ldtot += dl * (cprev.getR() + cq.getR());
                    MeshPoint[] acqn = cq.getNeighbors();
                    MeshPoint cnxt = acqn[0] == cprev ? acqn[1] : acqn[0];
                    cprev = cq;
                    cq = cnxt;
                    rq = cq.getR();
                }
                dl = Discretizer.distanceBetween(cprev, cq);
                ldtot += dl * (cprev.getR() + cq.getR());
                double lab = Discretizer.distanceBetween(cp, cq);
                double ldab = lab * (cp.getR() + cq.getR());
                int nadd = (int)((ltot += dl) / maxlen);
                if (nadd > vpt.size()) {
                    nadd = vpt.size();
                }
                boolean bl = cor = Math.abs((lab - ltot) / (lab + ltot)) > 0.5 * tol || Math.abs((ldab - ldtot) / (ldab + ldtot)) > 0.5 * tol;
                if (cor && nadd == 0) {
                    nadd = 1;
                }
                if (nadd == 0) {
                    cp.replaceNeighbor((MeshPoint)vpt.get(0), cq);
                    cq.replaceNeighbor((MeshPoint)vpt.get(vpt.size() - 1), cp);
                } else {
                    int i = 0;
                    while (i < nadd) {
                        MeshPoint cm = (MeshPoint)vpt.get(i);
                        cm.setWork(1);
                        Discretizer.locateBetween(cp, cq, (1.0 + (double)i) / (1.0 + (double)nadd), cm);
                        if (i == nadd - 1 && nadd < vpt.size()) {
                            cm.replaceNeighbor((MeshPoint)vpt.get(nadd), cq);
                            cq.replaceNeighbor((MeshPoint)vpt.get(vpt.size() - 1), cm);
                        }
                        ++i;
                    }
                }
                int jd = nadd;
                while (jd < vpt.size()) {
                    MeshPoint cd = (MeshPoint)vpt.get(jd);
                    cd.disconnect();
                    cd.setWork(0);
                    ++jd;
                }
                if (cor) {
                    double dpar = lab / (double)(nadd + 1);
                    double fl = ltot / lab;
                    double dperp = Math.sqrt((fl * fl - 1.0) * dpar * dpar);
                    double fr = ldtot / (fl * ldab);
                    int i = 0;
                    while (i < nadd) {
                        MeshPoint cm = (MeshPoint)vpt.get(i);
                        double cmr = cm.getR();
                        cm.setR(cmr * fr);
                        if (i % 2 == 0) {
                            Discretizer.movePerp(cp, cq, i / 2 % 2 == 0 ? dperp : -dperp, cm);
                        }
                        ++i;
                    }
                }
            }
            if (cq.getWork() == 2) {
                Discretizer.recMerge(cq, maxdr, maxlen, tol);
            }
            ++j;
        }
    }

    public static double[] getSubdivision(MeshPoint cpa, MeshPoint cpb, double disqrtr) {
        double dab = Discretizer.distanceBetween(cpa, cpb);
        double ra = cpa.getR();
        double rb = cpb.getR();
        double fdist = 0.0;
        fdist = rb != ra ? 0.6666666666666666 * dab / (rb - ra) * (Math.pow(rb, 1.5) - Math.pow(ra, 1.5)) : dab * Math.sqrt(ra);
        int nadd = (int)(fdist / disqrtr);
        double[] dpos = new double[nadd];
        if (nadd > 0) {
            if (Math.abs((ra - rb) / (ra + rb)) < 0.01) {
                int i = 0;
                while (i < nadd) {
                    dpos[i] = (1.0 + (double)i) / ((double)nadd + 1.0);
                    ++i;
                }
            } else {
                double delf = fdist / (double)(nadd + 1);
                double ffa = (rb - ra) / dab;
                double xa = ra / ffa;
                double xb = rb / ffa;
                double x = xa;
                int i = 0;
                while (i < nadd + 1) {
                    double ttt = delf * ffa * 3.0 / 2.0 + Math.pow(ffa * x, 1.5);
                    double dx = Math.pow(ttt, 0.6666666666666666) / ffa - x;
                    x += dx;
                    if (i < nadd) {
                        dpos[i] = (x - xa) / dab;
                    }
                    ++i;
                }
                if (Math.abs(xb - x) > 1.0E-5) {
                    Discretizer.Sp("ERROR : ECNet segment division " + xa + " " + xb + " " + x + " " + nadd + " " + dab + " " + ra + " " + rb);
                }
            }
        }
        return dpos;
    }

    public static void Sp(String s) {
        System.out.println(s);
    }
}

