/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial.xml;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import org.catacomb.report.E;
import org.catacomb.serial.xml.StringEncoder;
import org.catacomb.serial.xml.XMLToken;

public class XMLTokenizer {
    static int iq;
    static int ieq;
    static int iabo;
    static int iabc;
    static int iqm;
    static int iexc;
    static int ims;
    StreamTokenizer streamTokenizer;
    HashMap<String, String> cdataHM;
    String srcString;

    static {
        String sord = "\"=<>?!-";
        iq = sord.charAt(0);
        ieq = sord.charAt(1);
        iabo = sord.charAt(2);
        iabc = sord.charAt(3);
        iqm = sord.charAt(4);
        iexc = sord.charAt(5);
        ims = sord.charAt(6);
    }

    public XMLTokenizer(String s) {
        this.srcString = this.extractCDATAs(s);
        this.streamTokenizer = new StreamTokenizer(new StringReader(this.srcString));
        this.initializeStreamTokenizer(this.streamTokenizer);
    }

    private String extractCDATAs(String src) {
        StringBuffer sret = new StringBuffer();
        int icur = 0;
        int iscd = src.indexOf("<![CDATA[");
        while (iscd >= icur) {
            sret.append(src.substring(icur, iscd));
            int iecd = src.indexOf("]]>", iscd + 9);
            if (iecd >= 0) {
                String cdata = src.substring(iscd + 9, iecd);
                if (this.cdataHM == null) {
                    this.cdataHM = new HashMap();
                }
                String rpl = "xyz" + this.cdataHM.size();
                this.cdataHM.put(rpl, cdata);
                sret.append(rpl);
            } else {
                iecd = iscd + 6;
                E.error("no closure of cdata beginning character " + iscd + "? ");
            }
            icur = iecd + 3;
            iscd = src.indexOf("<![CDATA[", icur);
        }
        if (icur < src.length()) {
            sret.append(src.substring(icur, src.length()));
        }
        return sret.toString();
    }

    private void setStringValue(XMLToken xmlt, String svin) {
        String sv = svin;
        if (sv.startsWith("xyz")) {
            if (this.cdataHM != null && this.cdataHM.containsKey(sv)) {
                sv = this.cdataHM.get(sv);
            } else {
                E.warning("looks like a CDATA key, but not present? " + sv);
            }
        }
        xmlt.setStringValue(sv);
    }

    public int lineno() {
        return this.streamTokenizer.lineno();
    }

    public void initializeStreamTokenizer(StreamTokenizer st) {
        st.resetSyntax();
        st.eolIsSignificant(false);
        st.slashStarComments(false);
        st.slashSlashComments(false);
        st.lowerCaseMode(false);
        String slim = "AZaz09";
        st.wordChars(slim.charAt(0), slim.charAt(1));
        st.wordChars(slim.charAt(2), slim.charAt(3));
        st.wordChars(slim.charAt(4), slim.charAt(5));
        String wsc = " \t\n";
        int i = 0;
        while (i < wsc.length()) {
            char ic = wsc.charAt(i);
            st.whitespaceChars(ic, ic);
            ++i;
        }
        st.quoteChar(iq);
        String swc = "_/.:&;,()'+-.[]{}$";
        int i2 = 0;
        while (i2 < swc.length()) {
            char ic = swc.charAt(i2);
            st.wordChars(ic, ic);
            ++i2;
        }
    }

    public XMLToken nextToken() {
        XMLToken xmlt = new XMLToken();
        int itok = this.ntok(this.streamTokenizer);
        if (this.streamTokenizer.ttype == -1) {
            xmlt.setType(0);
        } else if (itok == iq) {
            xmlt.setType(4);
            String sss = this.streamTokenizer.sval;
            this.setStringValue(xmlt, StringEncoder.xmlUnescape(sss));
        } else if (this.streamTokenizer.ttype == -3) {
            xmlt.setType(4);
            this.setStringValue(xmlt, StringEncoder.xmlUnescape(this.streamTokenizer.sval));
        } else if (this.streamTokenizer.ttype == -2) {
            xmlt.setType(3);
            double d = this.streamTokenizer.nval;
            this.ntok(this.streamTokenizer);
            if (this.streamTokenizer.ttype == -3 && (this.streamTokenizer.sval.startsWith("E-") || this.streamTokenizer.sval.startsWith("E+") || this.streamTokenizer.sval.startsWith("E"))) {
                String s = this.streamTokenizer.sval.substring(1, this.streamTokenizer.sval.length());
                int ppp = Integer.parseInt(s);
                d *= Math.pow(10.0, ppp);
            } else {
                this.streamTokenizer.pushBack();
            }
            xmlt.setDValue(d);
        } else if (itok == iabo) {
            itok = this.ntok(this.streamTokenizer);
            String sv = this.streamTokenizer.sval;
            if (itok == iqm) {
                xmlt.setType(6);
                String svalue = "";
                itok = -1;
                while (itok != iqm) {
                    itok = this.ntok(this.streamTokenizer);
                    if (this.streamTokenizer.sval == null) continue;
                    svalue = String.valueOf(svalue) + this.streamTokenizer.sval + " ";
                }
                this.setStringValue(xmlt, svalue);
            } else if (itok == iexc) {
                itok = this.ntok(this.streamTokenizer);
                String sval = this.streamTokenizer.sval;
                String svalue = "";
                if (sval != null && sval.startsWith("[CDATA[")) {
                    E.error("shouldn't get CDATA in xml tokenizer");
                } else if (sval != null && sval.startsWith("--")) {
                    xmlt.setType(7);
                    svalue = String.valueOf(this.streamTokenizer.sval.substring(2, this.streamTokenizer.sval.length())) + " ";
                    while (itok != iabc) {
                        itok = this.ntok(this.streamTokenizer);
                        if (this.streamTokenizer.ttype == -3) {
                            svalue = String.valueOf(svalue) + this.streamTokenizer.sval + " ";
                            continue;
                        }
                        if (this.streamTokenizer.ttype != -2) continue;
                        svalue = String.valueOf(svalue) + " " + this.streamTokenizer.nval;
                    }
                    this.streamTokenizer.pushBack();
                } else if (itok == ims) {
                    itok = this.ntok(this.streamTokenizer);
                    if (itok == ims) {
                        int[] ipr = new int[3];
                        while (ipr[0] != ims || ipr[1] != ims || ipr[2] != iabc) {
                            itok = this.ntok(this.streamTokenizer);
                            if (this.streamTokenizer.ttype == -3) {
                                svalue = String.valueOf(svalue) + this.streamTokenizer.sval + " ";
                            } else if (this.streamTokenizer.ttype == -2) {
                                svalue = String.valueOf(svalue) + " " + this.streamTokenizer.nval;
                            }
                            if (this.streamTokenizer.sval != null && this.streamTokenizer.sval.endsWith("--")) {
                                ipr[1] = ims;
                                ipr[2] = ims;
                                continue;
                            }
                            ipr[0] = ipr[1];
                            ipr[1] = ipr[2];
                            ipr[2] = itok;
                        }
                        this.streamTokenizer.pushBack();
                    } else {
                        E.error("found <!- but not followed by -  at " + this.streamTokenizer.lineno());
                    }
                } else {
                    E.error("found <! but not followed by -  at " + this.streamTokenizer.lineno());
                }
                this.setStringValue(xmlt, svalue);
            } else if (sv.startsWith("/")) {
                xmlt.setType(2);
                this.setStringValue(xmlt, sv.substring(1, sv.length()));
            } else if (sv.endsWith("/")) {
                xmlt.setType(5);
                this.setStringValue(xmlt, sv.substring(0, sv.length() - 1));
            } else {
                xmlt.setType(1);
                this.setStringValue(xmlt, sv);
            }
            itok = this.ntok(this.streamTokenizer);
            if (itok != iabc) {
                if (this.streamTokenizer.ttype == -3) {
                    String[] attNV = new String[160];
                    int natt = 0;
                    while (itok != iabc) {
                        if (this.streamTokenizer.ttype == -3) {
                            if (this.streamTokenizer.sval.equals("/")) {
                                xmlt.setType(5);
                            } else {
                                attNV[2 * natt] = this.streamTokenizer.sval;
                                itok = this.ntok(this.streamTokenizer);
                                if (itok == ieq) {
                                    itok = this.ntok(this.streamTokenizer);
                                    if (itok == iq) {
                                        attNV[2 * natt + 1] = this.streamTokenizer.sval;
                                        ++natt;
                                    } else {
                                        E.shortError("expecting quoted string  while reading atributes but got " + this.stok(itok) + " sval=" + this.streamTokenizer.sval + " nval=" + this.streamTokenizer.nval);
                                        E.info("original string was " + this.srcString);
                                    }
                                } else {
                                    E.shortError("at " + this.streamTokenizer.lineno() + " expecting = while reading attributes " + "but got " + this.stok(itok) + " sval=" + this.streamTokenizer.sval + " nval=" + this.streamTokenizer.nval);
                                    E.info("original string was " + this.srcString);
                                }
                            }
                        } else {
                            E.shortError("at line " + this.streamTokenizer.lineno() + " found non-word while reading attributes " + this.stok(itok) + "  item so far = " + this);
                            E.info("original string was " + this.srcString);
                        }
                        itok = this.ntok(this.streamTokenizer);
                    }
                    String[] sat = new String[2 * natt];
                    int i = 0;
                    while (i < 2 * natt) {
                        sat[i] = attNV[i];
                        ++i;
                    }
                    xmlt.setAttributes(sat);
                } else {
                    E.error("expecting word " + this.stok(itok));
                }
            }
        } else {
            xmlt.setType(4);
            this.setStringValue(xmlt, this.stok(itok));
        }
        return xmlt;
    }

    private int ntok(StreamTokenizer st) {
        int itok = -1;
        try {
            itok = st.nextToken();
        }
        catch (IOException e) {
            this.err(" " + e);
            itok = -999;
        }
        return itok;
    }

    private String stok(int itok) {
        return "" + (char)itok;
    }

    private void err(String s) {
        System.out.println(s);
    }
}

