/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.util;

import java.awt.Color;
import org.catacomb.report.E;
import org.catacomb.util.StandardColors;

public class ColorUtil {
    static StandardColors standardColors;
    static String[] stdColorNames;
    static Color[] stdColors;

    static {
        stdColorNames = new String[]{"white", "black", "red", "green", "blue", "magenta", "cyan", "yellow", "orange", "pink", "gray"};
        stdColors = new Color[]{Color.white, Color.black, Color.red, Color.green, Color.blue, Color.magenta, Color.cyan, Color.yellow, Color.orange, Color.pink, Color.gray};
    }

    public static final Color brighter(Color c) {
        return ColorUtil.linMod(c, 30);
    }

    public static final Color darker(Color c) {
        return ColorUtil.linMod(c, -30);
    }

    public static final Color slightlyBrighter(Color c) {
        return ColorUtil.linMod(c, 16);
    }

    public static final Color slightlyDarker(Color c) {
        return ColorUtil.linMod(c, -16);
    }

    public static final Color verySlightlyBrighter(Color c) {
        Color ret = ColorUtil.linMod(c, 8);
        return ret;
    }

    public static final Color verySlightlyDarker(Color c) {
        Color ret = ColorUtil.linMod(c, -8);
        return ret;
    }

    public static final Color myBrighter(Color c) {
        return ColorUtil.linMod(c, 35);
    }

    public static final Color myDarker(Color c) {
        return ColorUtil.linMod(c, -35);
    }

    public static final Color linMod(Color c, int d) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        b += d;
        int n = (r += d) > 0 ? (r < 255 ? r : 255) : (r = 0);
        int n2 = g > 0 ? (g < 255 ? (g += d) : 255) : (g = 0);
        b = b > 0 ? (b < 255 ? b : 255) : 0;
        return new Color(r, g, b);
    }

    public static Color deserialize(String s) {
        return ColorUtil.parseColor(s);
    }

    public static Color parseColor(String s) {
        Color cret = Color.red;
        if (s == null || s.length() == 0) {
            cret = Color.orange;
            E.warning("asked to parse empty color");
        } else if (s.startsWith("#")) {
            cret = ColorUtil.parseHexColor(s);
        } else {
            cret = ColorUtil.simpleLookup(s);
            if (cret == null) {
                if (standardColors == null) {
                    Object obj = null;
                    E.missing("need to load standard cols from resource");
                    standardColors = obj;
                }
                cret = standardColors.defines(s) ? standardColors.getColor(s) : ColorUtil.parseHexColor(s);
            }
        }
        return cret;
    }

    private static Color simpleLookup(String s) {
        Color ret = null;
        int i = 0;
        while (i < stdColors.length) {
            if (s.equals(stdColorNames[i])) {
                ret = stdColors[i];
                break;
            }
            ++i;
        }
        return ret;
    }

    public static Color parseHexColor(String s) {
        Color cret = null;
        try {
            int ic = Integer.decode(s);
            cret = new Color(ic);
        }
        catch (NumberFormatException ex) {
            E.error("cant decode color string " + s);
            cret = Color.red;
        }
        return cret;
    }

    public static Color oldParseColor(String s) {
        Color ret = Color.black;
        if (s != null && s.startsWith("#") && s.length() == 7) {
            String s1 = s.substring(1, s.length());
            int icol = Integer.parseInt(s1, 16);
            ret = new Color(icol);
        } else {
            E.error(" - cant read color " + s);
        }
        return ret;
    }

    public static String serializeColor(Color c) {
        String ret = null;
        if (c == null) {
            ret = "#000000";
        } else {
            int rgb = c.getRGB();
            int xrgb = rgb | 0xFF000000;
            String fullhex = Integer.toHexString(xrgb);
            ret = "#" + fullhex.substring(2, 8);
        }
        return ret;
    }

    public static String hexString(Color c) {
        return ColorUtil.serializeColor(c);
    }
}

