/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.util;

import java.io.StringWriter;
import java.util.StringTokenizer;
import org.catacomb.util.Diff;
import org.catacomb.util.DiffPrint;
import org.catacomb.util.WSString;

public class DiffStrings {
    public static void compare(String s1, String s2) {
        DiffStrings.compare(s1, s2, true);
    }

    public static void compareNonWhitespace(String s1, String s2) {
        DiffStrings.compare(s1, s2, false);
    }

    public static void compare(String s1, String s2, boolean wsMatters) {
        Object[] sa1 = DiffStrings.lineArray(s1, wsMatters);
        Object[] sa2 = DiffStrings.lineArray(s2, wsMatters);
        Diff diff = new Diff(sa1, sa2);
        Diff.change script = diff.diff_2(false);
        DiffPrint.UnifiedPrint p = new DiffPrint.UnifiedPrint(sa1, sa2);
        StringWriter wtr = new StringWriter();
        p.setOutput(wtr);
        p.print_script(script);
        String sres = wtr.toString().trim();
        if (sres.length() == 0) {
            System.out.println("Diff: The strings are the same (" + (wsMatters ? "including" : "ignoring") + " whitespace)");
        } else {
            System.out.println("Diff: The strings differ:");
            System.out.println(sres);
        }
    }

    public static Object[] lineArray(String s, boolean wsMatters) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        int nt = st.countTokens();
        Object[] ret = new Object[nt];
        int i = 0;
        while (i < nt) {
            String tok = st.nextToken();
            ret[i] = wsMatters ? tok : new WSString(tok);
            ++i;
        }
        return ret;
    }
}

