/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.xdoc;

import org.catacomb.interlish.structure.Page;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.xdoc.TextTagger;

public class HTMLPage
implements Page {
    String htmlTemplate;
    String htmlPageText;
    String sourceText;
    public static final int PLAIN_TEXT = 1;
    public static final int DASSIE_TEXT = 2;
    public int sourceStyle = 1;

    public HTMLPage() {
        this.htmlPageText = "";
    }

    public HTMLPage(String s) {
        this.sourceText = s;
        this.htmlPageText = null;
    }

    public HTMLPage(String s, int iss) {
        this.sourceText = s;
        this.sourceStyle = iss;
        this.htmlPageText = null;
    }

    public void setSourceStyle(int iss) {
        this.sourceStyle = iss;
    }

    public void loadDefault() {
        this.htmlPageText = JUtil.getRelativeResource(this, "homePageHTML.txt");
    }

    @Override
    public String getHTMLText() {
        if (this.htmlPageText == null && this.sourceText != null) {
            this.wrapText(this.sourceText);
        }
        return this.htmlPageText;
    }

    public void setSourceText(String s) {
        this.sourceText = s;
        this.htmlPageText = null;
    }

    public void setSourceDassieText(String s) {
        this.sourceStyle = 2;
        this.sourceText = s;
        this.htmlPageText = null;
    }

    private String getHTMLTemplate() {
        if (this.htmlTemplate == null) {
            this.htmlTemplate = JUtil.getRelativeResource(this, "baseTemplateHTML.txt");
        }
        return this.htmlTemplate;
    }

    public void wrapText(String txt) {
        String sr = null;
        sr = this.sourceStyle == 1 ? this.wrapPlainString(txt) : this.wrapDassieString(txt);
        this.wrapHTMLText(sr);
    }

    private String wrapPlainString(String txtin) {
        String txt = txtin;
        StringBuffer textSB = new StringBuffer();
        textSB.append("<p>");
        txt = txt.replaceAll(" -p- ", " </p>\n<p> ");
        txt = txt.replaceAll(" -br- ", " <br>\n ");
        textSB.append(txt);
        textSB.append("</p>");
        return textSB.toString();
    }

    public String wrapDassieString(String txt) {
        String ret = TextTagger.getTagger().tagText(txt);
        return ret;
    }

    public void wrapHTMLText(String s) {
        String txt = this.getHTMLTemplate();
        int ibo = txt.indexOf("BODY");
        this.htmlPageText = String.valueOf(txt.substring(0, ibo)) + s + txt.substring(ibo + 4, txt.length());
    }

    public void loadText(String fnm) {
        this.htmlPageText = JUtil.getRelativeResource(this, fnm);
    }
}

