/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.disc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.textensor.report.E;
import org.textensor.stochdiff.disc.DiscretizedSpine;
import org.textensor.stochdiff.geom.GRotation;
import org.textensor.stochdiff.geom.Geom;
import org.textensor.stochdiff.geom.Position;
import org.textensor.stochdiff.geom.Translation;
import org.textensor.stochdiff.geom.Vector;
import org.textensor.stochdiff.numeric.math.MersenneTwister;
import org.textensor.stochdiff.numeric.math.RandomMath;
import org.textensor.stochdiff.numeric.morph.SpineDistribution;
import org.textensor.stochdiff.numeric.morph.SpinePopulation;
import org.textensor.stochdiff.numeric.morph.SpineProfile;
import org.textensor.stochdiff.numeric.morph.VolumeElement;
import org.textensor.stochdiff.numeric.morph.VolumeGrid;
import org.textensor.util.ArrayUtil;

public class SpineLocator {
    long spineSeed;
    SpineDistribution spineDist;
    double spineDX;
    MersenneTwister rngen;
    HashMap<SpineProfile, DiscretizedSpine> profHM;

    public SpineLocator(int seed, SpineDistribution sd, double delta) {
        this.spineSeed = seed;
        this.spineDist = sd;
        this.spineDX = delta;
        if (this.spineSeed <= 0L) {
            this.spineSeed = (long)(100000.0 * Math.random());
        }
        this.rngen = new MersenneTwister();
        this.rngen.setSeed(this.spineSeed);
    }

    public void addSpinesTo(VolumeGrid volumeGrid) {
        SpinePopulation[] spinePopulationArray = this.spineDist.getPopulations();
        int n = spinePopulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpinePopulation sp = spinePopulationArray[n2];
            String popid = sp.getID();
            if (popid == null) {
                popid = "";
            }
            double density = sp.getDensity();
            String reg = sp.getTargetRegion();
            ArrayList<VolumeElement> surfVE = new ArrayList<VolumeElement>();
            ArrayList<Double> surfA = new ArrayList<Double>();
            for (VolumeElement ve : volumeGrid.getElementsInRegion(reg)) {
                Position[] sbdry = ve.getSurfaceBoundary();
                if (sbdry == null) continue;
                surfVE.add(ve);
                surfA.add(new Double(Geom.getArea(sbdry)));
            }
            if (surfA.size() <= 0) {
                E.warning("there no elements labelled with " + reg + " but it is referenced from spine allocation");
            } else {
                double[] eltSA = new double[surfA.size()];
                double sum = 0.0;
                int i = 0;
                while (i < eltSA.length) {
                    eltSA[i] = sum += ((Double)surfA.get(i)).doubleValue();
                    ++i;
                }
                E.info("total surface area for spine group  " + popid + " on " + reg + " is " + sum);
                double totalArea = eltSA[eltSA.length - 1];
                double avgNoSpines = totalArea * density;
                double nspines = RandomMath.poissonInt(avgNoSpines, this.rngen);
                this.rngen.setSeed(this.spineSeed);
                if (nspines > 0.5 * (double)eltSA.length) {
                    E.error("too many spines (need more than one per segment");
                    nspines = (int)(0.5 * (double)eltSA.length);
                }
                HashSet<Integer> gotSpine = new HashSet<Integer>();
                int ndone = 0;
                if (avgNoSpines > 0.0 && nspines == 0.0) {
                    E.info("spines : although the density is non-zero, random allocation gives no spines for region " + reg + " (avg=" + avgNoSpines + ")");
                }
                while ((double)ndone < nspines) {
                    Integer ip;
                    double abelow = (double)this.rngen.random() * totalArea;
                    int posInArray = ArrayUtil.findBracket(eltSA, abelow);
                    if (posInArray < 0) {
                        E.info("tot area " + totalArea);
                        E.dump("cant get pos " + abelow, eltSA);
                    }
                    if (gotSpine.contains(ip = new Integer(posInArray))) continue;
                    gotSpine.add(ip);
                    ArrayList<VolumeElement> elts = this.addSpineTo((VolumeElement)surfVE.get(posInArray), sp.getProfile(), popid, ndone);
                    volumeGrid.addElements(elts);
                    ++ndone;
                }
            }
            ++n2;
        }
    }

    private ArrayList<VolumeElement> addSpineTo(VolumeElement vedend, SpineProfile prof, String popid, int idx) {
        Position[] perim = vedend.getSurfaceBoundary();
        Vector vnorm = Geom.getUnitNormal(perim);
        Position pcen = Geom.cog(perim);
        DiscretizedSpine xw = this.getBoundaryWidths(prof, this.spineDX);
        double[] xp = xw.getBoundaries();
        double[] wb = xw.getWidths();
        String[] lbls = xw.getLabels();
        String[] rgns = xw.getRegions();
        double[] rb = new double[wb.length];
        int i = 0;
        while (i < wb.length) {
            rb[i] = 0.5 * wb[i];
            ++i;
        }
        ArrayList<VolumeElement> ret = new ArrayList<VolumeElement>();
        Translation trans = Geom.translation(pcen);
        double theta = Geom.zRotationAngle(Geom.unitX(), vnorm);
        GRotation rot = Geom.aboutZRotation(theta);
        VolumeElement vprev = vedend;
        int i2 = 0;
        while (i2 < xp.length - 1) {
            double dx = xp[i2 + 1] - xp[i2];
            double vol = Math.PI * dx * (rb[i2] * rb[i2] + rb[i2 + 1] * rb[i2 + 1] + rb[i2] * rb[i2 + 1]) / 3.0;
            double baseArea = Math.PI * (rb[i2] * rb[i2]);
            VolumeElement ve = new VolumeElement();
            Position cp = Geom.position(0.5 * (xp[i2] + xp[i2 + 1]), 0.0, 0.0);
            Position pr = rot.getRotatedPosition(cp);
            Position pc = trans.getTranslated(pr);
            ve.setCenterPosition(pc.getX(), pc.getY(), pc.getZ());
            Position[] pbdry = new Position[]{Geom.position(xp[i2 + 1], rb[i2 + 1], 0.0), Geom.position(xp[i2], rb[i2], 0.0), Geom.position(xp[i2], -rb[i2], 0.0), Geom.position(xp[i2 + 1], -rb[i2 + 1], 0.0)};
            int ib = 0;
            while (ib < pbdry.length) {
                pbdry[ib] = trans.getTranslated(rot.getRotatedPosition(pbdry[ib]));
                ++ib;
            }
            ve.setBoundary(pbdry);
            ve.setVolume(vol);
            ve.setDeltaZ(0.5 * (rb[i2] + rb[i2 + 1]));
            vprev.coupleTo(ve, baseArea);
            ret.add(ve);
            String lroot = String.valueOf(popid) + "[" + idx + "]";
            if (lbls[i2] != null) {
                String ll = String.valueOf(lroot) + "." + lbls[i2];
                ve.setLabel(ll);
            } else {
                ve.setGroupID(lroot);
            }
            if (rgns[i2] != null) {
                ve.setRegion(rgns[i2]);
            }
            vprev = ve;
            ++i2;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private DiscretizedSpine getBoundaryWidths(SpineProfile sp, double dx) {
        block9: {
            block8: {
                if (this.profHM == null) {
                    this.profHM = new HashMap<K, V>();
                }
                ret = null;
                if (!this.profHM.containsKey(sp)) break block8;
                ret = this.profHM.get(sp);
                break block9;
            }
            ax = sp.getXPts();
            aw = sp.getWidths();
            pl = sp.getLabels();
            prl = sp.getRegions();
            ltot = ax[ax.length - 1];
            nel = (int)(ltot / dx + 0.5);
            if (nel < 1) {
                nel = 1;
            }
            xbd = ArrayUtil.span(0.0, ltot, nel);
            wv = ArrayUtil.interpInAtFor(aw, ax, xbd);
            lbls = new String[nel];
            rgns = new String[nel];
            ipr = 0;
            i = 0;
            ** GOTO lbl30
            {
                ++ipr;
                do {
                    if (ipr < ax.length - 2 && ax[ipr + 1] < xbd[i]) continue block0;
                    db = xbd[i] - ax[ipr];
                    df = ax[ipr + 1] - xbd[i];
                    rgns[i] = db < df ? prl[ipr] : prl[ipr + 1];
                    ++i;
lbl30:
                    // 2 sources

                } while (i < nel);
            }
            i = 0;
            while (i < ax.length) {
                if (pl[i] != null) {
                    dmin = 1000000.0;
                    imin = 0;
                    j = 0;
                    while (j < nel) {
                        d = Math.abs(xbd[j] - ax[i]);
                        if (d < dmin) {
                            dmin = d;
                            imin = j;
                        }
                        ++j;
                    }
                    lbls[imin] = pl[i];
                }
                ++i;
            }
            ret = new DiscretizedSpine(xbd, wv, lbls, rgns);
        }
        return ret;
    }
}

