/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.disc;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.textensor.report.E;
import org.textensor.stochdiff.numeric.morph.TreePoint;

public class TreeUtil {
    public static void parentizeFrom(TreePoint base, TreePoint[] srcPoints) {
        TreePoint[] treePointArray = srcPoints;
        int n = srcPoints.length;
        int n2 = 0;
        while (n2 < n) {
            TreePoint tp = treePointArray[n2];
            tp.iwork = 1;
            ++n2;
        }
        ConcurrentLinkedQueue<TreePoint> q = new ConcurrentLinkedQueue<TreePoint>();
        q.add(base);
        while (!q.isEmpty()) {
            TreePoint tp = (TreePoint)q.remove();
            int i = 0;
            while (i < tp.nnbr) {
                TreePoint tpn = tp.nbr[i];
                if (tpn.iwork == 1) {
                    tpn.iwork = 0;
                    tpn.parent = tp;
                    q.add(tpn);
                }
                ++i;
            }
        }
    }

    public static void orientAC(TreePoint base, TreePoint[] srcPoints) {
        TreePoint[] treePointArray = srcPoints;
        int n = srcPoints.length;
        int n2 = 0;
        while (n2 < n) {
            TreePoint tp = treePointArray[n2];
            tp.iwork = 1;
            ++n2;
        }
        ConcurrentLinkedQueue<TreePoint> q = new ConcurrentLinkedQueue<TreePoint>();
        q.add(base);
        while (!q.isEmpty()) {
            TreePoint tp = (TreePoint)q.remove();
            tp.iwork = 0;
            int i = 1;
            while (i < tp.nnbr) {
                if (tp.nbr[i] == tp.parent) {
                    tp.nbr[i] = tp.nbr[0];
                    tp.nbr[0] = tp.parent;
                    break;
                }
                ++i;
            }
            if (tp.nnbr >= 3) {
                TreeUtil.orientOneAC(tp);
            }
            i = 0;
            while (i < tp.nnbr) {
                TreePoint tpn = tp.nbr[i];
                if (tpn.iwork == 1) {
                    tpn.iwork = 0;
                    q.add(tpn);
                }
                ++i;
            }
        }
    }

    private static void orientOneAC(TreePoint tp) {
        double[][] ds = new double[tp.nnbr][2];
        TreePoint wk = tp.parent;
        if (tp.distanceTo(wk) < 0.1) {
            wk = wk.parent;
        }
        ds[0][0] = wk.getX() - tp.getX();
        ds[0][1] = wk.getY() - tp.getY();
        int i = 1;
        while (i < tp.nnbr) {
            wk = tp.nbr[i];
            if (tp.distanceTo(wk) < 0.1) {
                if (wk.nnbr >= 2) {
                    wk = wk.nbr[1];
                } else {
                    E.error("problem orienting children of " + tp);
                }
            }
            ds[i][0] = wk.getX() - tp.getX();
            ds[i][1] = wk.getY() - tp.getY();
            ++i;
        }
        double[] ang = new double[tp.nnbr];
        int i2 = 0;
        while (i2 < tp.nnbr) {
            ang[i2] = Math.atan2(ds[i2][1], ds[i2][0]);
            ++i2;
        }
        i2 = 1;
        while (i2 < tp.nnbr) {
            ang[i2] = (ang[i2] - ang[0] + Math.PI * 4) % (Math.PI * 2);
            ++i2;
        }
        ang[0] = 0.0;
        if (tp.nnbr == 3) {
            if (ang[1] > ang[2]) {
                TreePoint dum = tp.nbr[1];
                tp.nbr[1] = tp.nbr[2];
                tp.nbr[2] = dum;
            }
        } else {
            E.missing("can't handle points with more than three neighbors yet");
        }
    }
}

