/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.geom;

import org.textensor.report.E;
import org.textensor.stochdiff.geom.GTranslation;
import org.textensor.stochdiff.geom.GVector;
import org.textensor.stochdiff.geom.Geom;
import org.textensor.stochdiff.geom.Movable;
import org.textensor.stochdiff.geom.Position;
import org.textensor.stochdiff.geom.Rotation;
import org.textensor.stochdiff.geom.Vector;

public class GRotation
implements Rotation {
    public static final String Z_AXIS = "zaxis";
    public static final String Y_AXIS = "yaxis";
    double[][] mtx = new double[3][3];

    public GRotation() {
        int i = 0;
        while (i < 3) {
            this.mtx[i][i] = 1.0;
            ++i;
        }
    }

    public GRotation(String axis, double angle) {
        this();
        double ca = Math.cos(angle);
        double sa = Math.sin(angle);
        if (axis.equals(Z_AXIS)) {
            this.mtx[0][0] = ca;
            this.mtx[0][1] = -sa;
            this.mtx[1][0] = sa;
            this.mtx[1][1] = ca;
        } else if (axis.equals(Y_AXIS)) {
            this.mtx[0][0] = ca;
            this.mtx[0][2] = -sa;
            this.mtx[2][0] = sa;
            this.mtx[2][2] = ca;
        } else {
            E.error("unknown axis " + axis);
        }
    }

    @Override
    public Vector getRotatedVector(Vector v) {
        double[] d = new double[]{v.getDX(), v.getDY(), v.getDZ()};
        double[] r = new double[3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int n = i;
                r[n] = r[n] + this.mtx[i][j] * d[j];
                ++j;
            }
            ++i;
        }
        return new GVector(r);
    }

    @Override
    public Position getRotatedPosition(Position p, Position pcenter) {
        Vector v = Geom.fromToVector(pcenter, p);
        Vector vnew = this.getRotatedVector(v);
        GTranslation trans = new GTranslation(vnew);
        return trans.getTranslated(pcenter);
    }

    @Override
    public void rotateAbout(Movable mov, Position pcenter) {
    }

    public GRotation times(GRotation gr1) {
        GRotation ret = new GRotation();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                ret.mtx[i][j] = 0.0;
                int k = 0;
                while (k < 3) {
                    double[] dArray = ret.mtx[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.mtx[i][k] * gr1.mtx[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public Position getRotatedPosition(Position p) {
        Vector v = Geom.getToVector(p);
        Vector vr = this.getRotatedVector(v);
        return Geom.endPosition(vr);
    }
}

