/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.geom;

import org.textensor.stochdiff.geom.GPosition;
import org.textensor.stochdiff.geom.GRotation;
import org.textensor.stochdiff.geom.GTranslation;
import org.textensor.stochdiff.geom.GVector;
import org.textensor.stochdiff.geom.Position;
import org.textensor.stochdiff.geom.Rotation;
import org.textensor.stochdiff.geom.Translation;
import org.textensor.stochdiff.geom.Vector;

public final class Geom {
    public static Position midpoint(Position p1, Position p2) {
        return new GPosition(0.5 * (p1.getX() + p2.getX()), 0.5 * (p1.getY() + p2.getY()), 0.5 * (p1.getZ() + p2.getZ()));
    }

    public static Translation translation(Position p) {
        return new GTranslation(p);
    }

    public static Vector fromToVector(Position p1, Position p2) {
        return new GVector(p2.getX() - p1.getX(), p2.getY() - p1.getY(), p2.getZ() - p1.getZ());
    }

    public static Vector unitX() {
        return new GVector(1.0, 0.0, 0.0);
    }

    public static Vector unitY() {
        return new GVector(0.0, 1.0, 0.0);
    }

    public static Vector unitZ() {
        return new GVector(0.0, 0.0, 1.0);
    }

    public static Vector xyProjection(Vector v) {
        return new GVector(v.getDX(), v.getDY(), 0.0);
    }

    public static Rotation fromZRotation(Vector v) {
        Vector v1 = Geom.unitZ();
        double phi = Geom.angleBetween(v1, v);
        GRotation gr1 = Geom.aboutYRotation(phi);
        Vector vp = Geom.xyProjection(v);
        double theta = Geom.angleBetween(Geom.unitX(), vp);
        GRotation gr2 = Geom.aboutZRotation(theta);
        GRotation grot = gr2.times(gr1);
        return grot;
    }

    public static GRotation aboutZRotation(double angle) {
        GRotation gr = new GRotation("zaxis", angle);
        return gr;
    }

    public static GRotation aboutYRotation(double angle) {
        GRotation gr = new GRotation("yaxis", angle);
        return gr;
    }

    public static double length(Vector v) {
        double x = v.getDX();
        double y = v.getDY();
        double z = v.getDZ();
        double l2 = x * x + y * y + z * z;
        double l = Math.sqrt(l2);
        return l;
    }

    public static double dotProduct(Vector v1, Vector v2) {
        double d = 0.0;
        d += v1.getDX() * v2.getDX();
        d += v1.getDY() * v2.getDY();
        return d += v1.getDZ() * v2.getDZ();
    }

    public static double angleBetween(Vector v1, Vector v2) {
        double cosphi = Geom.dotProduct(v1, v2) / (Geom.length(v1) * Geom.length(v2));
        double phi = Math.acos(cosphi);
        return phi;
    }

    public static double zRotationAngle(Vector v1, Vector v2) {
        double cx = v1.getDX() * v2.getDX() + v1.getDY() * v2.getDY();
        double cy = -1.0 * v1.getDY() * v2.getDX() + v1.getDX() * v2.getDY();
        double phi = Math.atan2(cy, cx);
        return phi;
    }

    public static Vector vector(double x, double y, double z) {
        return new GVector(x, y, z);
    }

    public static Position position(double x, double y, double z) {
        return new GPosition(x, y, z);
    }

    public static Vector getToVector(Position p) {
        return Geom.vector(p.getX(), p.getY(), p.getZ());
    }

    public static Position endPosition(Vector vr) {
        return Geom.position(vr.getDX(), vr.getDY(), vr.getDZ());
    }

    public static double distanceBetween(Position pa, Position pb) {
        return Geom.length(Geom.fromToVector(pa, pb));
    }

    public static double distanceBetween(double[] pa, double[] pb) {
        double dx = pb[0] - pa[0];
        double dy = pb[1] - pa[1];
        double dz = pb[2] - pa[2];
        double r2 = dx * dx + dy * dy + dz * dz;
        double r = Math.sqrt(r2);
        return r;
    }

    public static Position cog(Position[] perim) {
        int n = perim.length;
        GPosition pos = new GPosition();
        int i = 0;
        while (i < n) {
            pos.add(perim[i]);
            ++i;
        }
        GPosition ret = new GPosition(pos.getX() / (double)n, pos.getY() / (double)n, pos.getZ() / (double)n);
        return ret;
    }

    public static double getArea(Position[] perim) {
        Vector vec = Geom.getNormal(perim);
        double area = Geom.length(vec);
        return area;
    }

    public static Vector getNormal(Position[] perim) {
        GVector vec = new GVector();
        int n = perim.length;
        int i = 1;
        while (i < n - 2) {
            Vector pa = Geom.fromToVector(perim[0], perim[i]);
            Vector pb = Geom.fromToVector(perim[i], perim[i + 1]);
            vec.add(Geom.crossProduct(pa, pb));
            ++i;
        }
        return vec;
    }

    public static Vector getUnitNormal(Position[] perim) {
        Vector va = Geom.getNormal(perim);
        double d = Geom.length(va);
        GVector ret = new GVector(va.getDX() / d, va.getDY() / d, va.getDZ() / d);
        return ret;
    }

    public static Vector crossProduct(Vector pa, Vector pb) {
        double ax = pa.getDX();
        double ay = pa.getDY();
        double az = pa.getDZ();
        double bx = pb.getDX();
        double by = pb.getDY();
        double bz = pb.getDZ();
        double rx = ay * bz - az * by;
        double ry = az * bx - ax * bz;
        double rz = ax * by - ay * bx;
        return new GVector(rx, ry, rz);
    }
}

