/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import org.textensor.stochdiff.numeric.chem.ReactionTable;
import org.textensor.stochdiff.numeric.chem.StimulationTable;

public class InjectionStim {
    public String specieID;
    public String injectionSite;
    public double onset;
    public double duration;
    public double rate;
    public double period;
    public double end;
    public double interTrainInterval;
    public int numTrains;

    public void writeTo(StimulationTable stab, ReactionTable rtab) {
        int specInd = rtab.getSpecieIndex(this.specieID);
        double[] vrate = new double[rtab.getNSpecies()];
        vrate[specInd] = this.rate;
        if (this.numTrains == 0) {
            this.numTrains = 1;
        }
        int i = 0;
        while (i < this.numTrains) {
            if (this.period <= 0.0) {
                stab.addSquarePulse(this.injectionSite, vrate, this.onset + (double)i * (this.duration + this.interTrainInterval), this.duration);
            } else {
                stab.addPeriodicSquarePulse(this.injectionSite, vrate, this.onset + (double)i * (this.end - this.onset + this.interTrainInterval), this.duration, this.period, this.end + (double)i * (this.end - this.onset + this.interTrainInterval));
            }
            ++i;
        }
    }
}

