/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.model.Segment;
import org.textensor.stochdiff.numeric.morph.TreePoint;

public class MorphPoint {
    public String label;
    public double x = Double.NaN;
    public double y = Double.NaN;
    public double z = Double.NaN;
    public double r = Double.NaN;
    private Segment r_segment;
    protected MorphPoint r_peerPoint;
    private ArrayList<MorphPoint> neighbors;
    private ArrayList<MorphPoint> offsetNeighbors;
    public HashMap<MorphPoint, String> segidHM = new HashMap();
    public HashMap<MorphPoint, String> regionHM = new HashMap();

    public MorphPoint() {
    }

    public MorphPoint(String id, double ax, double ay, double az, double ar) {
        this();
        this.label = id;
        this.x = ax;
        this.y = ay;
        this.z = az;
        this.r = ar;
    }

    public void setSegment(Segment seg) {
        this.r_segment = seg;
    }

    protected void addNeighbor(MorphPoint p) {
        if (this.neighbors == null) {
            this.neighbors = new ArrayList();
        }
        this.neighbors.add(p);
    }

    public void addOffsetChild(MorphPoint p) {
        if (this.offsetNeighbors == null) {
            this.offsetNeighbors = new ArrayList();
        }
        this.offsetNeighbors.add(p);
    }

    public boolean hasOffsetChildren() {
        return this.offsetNeighbors != null;
    }

    public ArrayList<MorphPoint> getOffsetChildren() {
        return this.offsetNeighbors;
    }

    public void removeNeighbor(MorphPoint mp) {
        this.neighbors.remove(mp);
    }

    public boolean redundant() {
        return this.r_peerPoint != null;
    }

    public ArrayList<MorphPoint> getNeighbors() {
        return this.neighbors;
    }

    public TreePoint toTreePoint() {
        TreePoint tp = new TreePoint(this.x, this.y, this.z, this.r);
        if (this.label != null) {
            tp.setLabel(this.label);
        }
        return tp;
    }

    public void transferConnections() {
        if (this.r_peerPoint == null) {
            E.error("cant transfer connections - no peer");
        } else {
            if (this.neighbors != null) {
                for (MorphPoint mp : this.neighbors) {
                    mp.removeNeighbor(this);
                    this.r_peerPoint.addNeighbor(mp);
                    mp.addNeighbor(this.r_peerPoint);
                    if (this.segidHM.containsKey(mp)) {
                        this.r_peerPoint.setIDWith(mp, this.segidHM.get(mp));
                    }
                    if (this.regionHM.containsKey(mp)) {
                        this.r_peerPoint.setRegionWith(mp, this.regionHM.get(mp));
                    }
                    mp.replaceNeighborLabels(this, this.r_peerPoint);
                }
                this.neighbors = null;
            }
            if (this.offsetNeighbors != null) {
                for (MorphPoint mon : this.offsetNeighbors) {
                    this.r_peerPoint.addOffsetChild(mon);
                }
                this.offsetNeighbors = null;
            }
        }
    }

    public boolean hasPosition() {
        boolean ret = true;
        if (Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z)) {
            ret = false;
        }
        return ret;
    }

    public double distanceTo(MorphPoint mp) {
        double ret = 1.0;
        if (this.hasPosition() && mp.hasPosition()) {
            double dx = mp.x - this.x;
            double dy = mp.y - this.y;
            double dz = mp.z - this.z;
            ret = Math.sqrt(dx * dx + dy * dy + dz * dz);
        } else {
            E.error("cant calculate distance (undefined position)");
        }
        return ret;
    }

    public void setIDWith(MorphPoint end, String id) {
        this.segidHM.put(end, id);
    }

    public void setRegionWith(MorphPoint ep, String r) {
        this.regionHM.put(ep, r);
    }

    public void replaceNeighborLabels(MorphPoint mp, MorphPoint mpnew) {
        if (this.segidHM.containsKey(mp)) {
            this.segidHM.put(mpnew, this.segidHM.get(mp));
            this.segidHM.remove(mp);
        }
        if (this.regionHM.containsKey(mp)) {
            this.regionHM.put(mpnew, this.regionHM.get(mp));
            this.regionHM.remove(mp);
        }
    }
}

