/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.model.EndPoint;
import org.textensor.stochdiff.model.MorphPoint;
import org.textensor.stochdiff.model.Segment;
import org.textensor.stochdiff.model.SpineAllocation;
import org.textensor.stochdiff.model.SpineType;
import org.textensor.stochdiff.numeric.morph.SpineDistribution;
import org.textensor.stochdiff.numeric.morph.SpinePopulation;
import org.textensor.stochdiff.numeric.morph.TreePoint;

public class Morphology
implements AddableTo {
    public ArrayList<SpineType> spineTypes;
    public ArrayList<Segment> segments;
    boolean resolved = false;
    private ArrayList<MorphPoint> p_points;
    private ArrayList<SpineAllocation> p_spineAllocations;

    @Override
    public void add(Object obj) {
        if (obj instanceof Segment) {
            if (this.segments == null) {
                this.segments = new ArrayList();
            }
            this.segments.add((Segment)obj);
        } else if (obj instanceof SpineType) {
            if (this.spineTypes == null) {
                this.spineTypes = new ArrayList();
            }
            this.spineTypes.add((SpineType)obj);
        } else if (obj instanceof SpineAllocation) {
            if (this.p_spineAllocations == null) {
                this.p_spineAllocations = new ArrayList();
            }
            this.p_spineAllocations.add((SpineAllocation)obj);
        } else {
            E.error("cant ad a " + obj.getClass() + " to a morphology");
        }
    }

    public void resolve() {
        HashMap<String, SpineType> spineHM = new HashMap<String, SpineType>();
        if (this.spineTypes != null) {
            for (SpineType st : this.spineTypes) {
                spineHM.put(st.id, st);
            }
        }
        if (this.p_spineAllocations != null) {
            for (SpineAllocation ss : this.p_spineAllocations) {
                ss.resolve(spineHM);
            }
        }
        if (this.segments != null) {
            HashMap<String, Segment> segmentHM = new HashMap<String, Segment>();
            for (Segment seg : this.segments) {
                segmentHM.put(seg.getID(), seg);
            }
            for (Segment seg : this.segments) {
                seg.resolve(segmentHM);
            }
            ArrayList<EndPoint> wk = new ArrayList<EndPoint>();
            for (Segment segment2 : this.segments) {
                wk.add(segment2.getStart());
                wk.add(segment2.getEnd());
            }
            this.p_points = new ArrayList();
            for (MorphPoint morphPoint : wk) {
                if (morphPoint.redundant()) {
                    morphPoint.transferConnections();
                    continue;
                }
                this.p_points.add(morphPoint);
            }
        }
        this.resolved = true;
    }

    public TreePoint[] getTreePoints() {
        TreePoint tp;
        if (!this.resolved) {
            this.resolve();
        }
        ArrayList<TreePoint> tpts = new ArrayList<TreePoint>();
        HashMap<MorphPoint, TreePoint> mtHM = new HashMap<MorphPoint, TreePoint>();
        int ic = 0;
        for (MorphPoint mp : this.p_points) {
            tp = mp.toTreePoint();
            tpts.add(tp);
            mtHM.put(mp, tp);
            tp.setWork(ic);
            ++ic;
        }
        for (MorphPoint mp : this.p_points) {
            tp = (TreePoint)mtHM.get(mp);
            for (MorphPoint pn : mp.getNeighbors()) {
                TreePoint tpn = (TreePoint)mtHM.get(pn);
                if (tp.getWork() >= tpn.getWork()) continue;
                TreePoint.neighborize(tp, tpn);
            }
            for (MorphPoint pn : mp.segidHM.keySet()) {
                tp.setIDWith((TreePoint)mtHM.get(pn), mp.segidHM.get(pn));
            }
            for (MorphPoint pn : mp.regionHM.keySet()) {
                tp.setRegionWith((TreePoint)mtHM.get(pn), mp.regionHM.get(pn));
            }
            if (!mp.hasOffsetChildren()) continue;
            for (MorphPoint oc : mp.getOffsetChildren()) {
                TreePoint tpc = (TreePoint)mtHM.get(oc);
                tp.addOffsetChild(tpc);
            }
        }
        TreePoint[] ret = tpts.toArray(new TreePoint[0]);
        return ret;
    }

    public SpineDistribution getSpineDistribution() {
        ArrayList<SpinePopulation> spa = new ArrayList<SpinePopulation>();
        if (this.p_spineAllocations != null) {
            for (SpineAllocation sa : this.p_spineAllocations) {
                SpinePopulation sp = sa.makePopulation();
                if (sp == null) continue;
                spa.add(sp);
            }
        }
        SpinePopulation[] pa = spa.toArray(new SpinePopulation[0]);
        SpineDistribution sd = new SpineDistribution(pa);
        return sd;
    }
}

