/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.model.OutputSpecie;

public class OutputSet
implements AddableTo {
    public String filename;
    public String region;
    public String dt;
    public ArrayList<OutputSpecie> outputSpec;

    @Override
    public void add(Object obj) {
        if (this.outputSpec == null) {
            this.outputSpec = new ArrayList();
        }
        if (obj instanceof OutputSpecie) {
            this.outputSpec.add((OutputSpecie)obj);
        } else {
            E.error("cant add " + obj);
        }
    }

    public int getNumberOfOutputSpecies() {
        return this.outputSpec.size();
    }

    public String[] getNamesOfOutputSpecies() {
        int ns = this.outputSpec.size();
        String[] ret = new String[ns];
        int i = 0;
        while (i < ns) {
            ret[i] = this.outputSpec.get((int)i).name;
            ++i;
        }
        return ret;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean hasFname() {
        return this.filename != null;
    }

    public String getFname() {
        return this.filename;
    }

    public boolean hasdt() {
        return this.dt != null;
    }

    public double getdt() {
        return Double.parseDouble(this.dt);
    }

    public void print() {
        System.out.println("<OutputSet>");
        System.out.print(" filename: " + this.filename + " |region: ");
        if (this.hasRegion()) {
            System.out.print(this.region);
        } else {
            System.out.print("Not-Specified");
        }
        System.out.print(" |dt: ");
        if (this.hasdt()) {
            System.out.println(this.dt);
        } else {
            System.out.println(" default");
        }
        System.out.println("OutputSpecies: ");
        int i = 0;
        while (i < this.outputSpec.size()) {
            System.out.print(String.valueOf(this.outputSpec.get((int)i).name) + " ");
            ++i;
        }
        System.out.println();
    }
}

