/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.model.EndPoint;

public class Segment {
    public String id;
    public String region;
    public EndPoint start;
    public EndPoint end;
    private boolean resolved = false;

    public String getID() {
        return this.id;
    }

    public void checkResolved(HashMap<String, Segment> segmentHM) {
        if (!this.resolved) {
            this.resolve(segmentHM);
        }
    }

    public void resolve(HashMap<String, Segment> segmentHM) {
        this.start.setSegment(this);
        this.end.setSegment(this);
        this.start.resolve(segmentHM, this.end);
        this.end.resolve(segmentHM, this.start);
        this.start.addNeighbor(this.end);
        this.end.addNeighbor(this.start);
        if (this.region != null) {
            this.start.setRegionWith(this.end, this.region);
            this.end.setRegionWith(this.start, this.region);
        }
        if (this.id != null) {
            this.start.setIDWith(this.end, this.id);
            this.end.setIDWith(this.start, this.id);
        }
        this.resolved = true;
    }

    public EndPoint getStart() {
        return this.start;
    }

    public EndPoint getEnd() {
        return this.end;
    }

    public void checkHasPositions() {
        if (!this.start.hasPosition()) {
            E.error("start point of " + this.id + " still has no position " + this.start.writePos());
        }
        if (!this.end.hasPosition()) {
            E.error("start point of " + this.id + " still has no position " + this.start.writePos());
        }
    }
}

