/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.inter.FloatValued;
import org.textensor.stochdiff.model.SurfaceDensity;

public class SurfaceDensitySet
implements AddableTo {
    public String region;
    public ArrayList<SurfaceDensity> sds;
    HashMap<String, SurfaceDensity> sdHM;
    public boolean complete;

    @Override
    public void add(Object obj) {
        if (this.sds == null) {
            this.sds = new ArrayList();
        }
        if (obj instanceof SurfaceDensity) {
            this.sds.add((SurfaceDensity)obj);
        } else {
            E.error("cant add " + obj);
        }
    }

    public HashMap<String, SurfaceDensity> getSurfaceDensityHM() {
        if (this.sdHM == null) {
            this.sdHM = new HashMap();
            if (this.sds != null) {
                for (SurfaceDensity sd : this.sds) {
                    this.sdHM.put(sd.specieID, sd);
                }
            }
        }
        return this.sdHM;
    }

    public double[] getPicoSurfaceDensities(String[] ids) {
        double[] ret = new double[ids.length];
        HashMap<String, SurfaceDensity> chm = this.getSurfaceDensityHM();
        int i = 0;
        while (i < ids.length) {
            ret[i] = chm.containsKey(ids[i]) ? chm.get(ids[i]).getPicoMoleSurfaceDensity() : Double.NaN;
            ++i;
        }
        return ret;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getRegion() {
        return this.region;
    }

    public void addFloatValued(ArrayList<FloatValued> afv) {
        afv.addAll(this.sds);
    }
}

