/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.chem;

import org.textensor.report.E;
import org.textensor.stochdiff.numeric.math.Column;
import org.textensor.stochdiff.numeric.math.Matrix;

public class ReactionTable {
    int nreaction;
    public int nspecie;
    String[] speciesIDs;
    double[] diffusionConstants;
    int[][] reactantIndices;
    int[][] productIndices;
    int[][] reactantStochiometry;
    int[][] productStochiometry;
    double[] rates;
    Matrix productionMatrix;

    public ReactionTable(int nr, int ns) {
        this.nreaction = nr;
        this.nspecie = ns;
        this.reactantIndices = new int[this.nreaction][2];
        this.productIndices = new int[this.nreaction][2];
        this.reactantStochiometry = new int[this.nreaction][2];
        this.productStochiometry = new int[this.nreaction][2];
        int i = 0;
        while (i < this.nreaction) {
            int j = 0;
            while (j < 2) {
                this.reactantIndices[i][j] = -1;
                this.productIndices[i][j] = -1;
                ++j;
            }
            ++i;
        }
        this.rates = new double[this.nreaction];
    }

    public String[] getSpecieIDs() {
        return this.speciesIDs;
    }

    public void print() {
        StringBuffer sb = new StringBuffer();
        sb.append("nspecie = " + this.nspecie + "  nreaction = " + this.nreaction + "\n");
        int i = 0;
        while (i < this.nreaction) {
            sb.append("reaction " + i + ":      ");
            sb.append("" + this.reactantIndices[i][0]);
            sb.append(" (" + this.reactantStochiometry[i][0] + ")");
            if (this.reactantIndices[i][1] >= 0) {
                sb.append(" + " + this.reactantIndices[i][1]);
                sb.append(" (" + this.reactantStochiometry[i][1] + ")");
            }
            sb.append(" --> ");
            sb.append("" + this.productIndices[i][0]);
            sb.append(" (" + this.productStochiometry[i][0] + ")");
            if (this.productIndices[i][1] >= 0) {
                sb.append(" + " + this.productIndices[i][1]);
                sb.append(" (" + this.productStochiometry[i][1] + ")");
            }
            sb.append("   rate " + this.rates[i] + " \n");
            ++i;
        }
        E.info(sb.toString());
    }

    public void setReactionData(int ireact, int[][] aidx, int[][] bidx, double rate) {
        this.reactantIndices[ireact][0] = aidx[0][0];
        this.reactantStochiometry[ireact][0] = aidx[1][0];
        if (aidx[0].length > 1) {
            this.reactantIndices[ireact][1] = aidx[0][1];
            this.reactantStochiometry[ireact][1] = aidx[1][1];
        }
        this.productIndices[ireact][0] = bidx[0][0];
        this.productStochiometry[ireact][0] = bidx[1][0];
        if (bidx[0].length > 1) {
            this.productIndices[ireact][1] = bidx[0][1];
            this.productStochiometry[ireact][1] = bidx[1][1];
        }
        this.rates[ireact] = rate;
        if (aidx.length > 2) {
            E.error("cant handle reactions with more than two reactants");
        }
        if (bidx.length > 2) {
            E.error("cant handle reactions with more than two products");
        }
    }

    public void setCatalyzedReactionData(int ireact, int na, int nb, int icat, int[][] aidx, int[][] bidx, double rate) {
        E.missing();
    }

    public void setSpeciesIDs(String[] sa) {
        this.speciesIDs = sa;
    }

    public String[] getSpeciesIDs() {
        return this.speciesIDs;
    }

    public int getNSpecies() {
        return this.nspecie;
    }

    public void setDiffusionConstants(double[] d) {
        this.diffusionConstants = d;
    }

    public double[] getDiffusionConstants() {
        return this.diffusionConstants;
    }

    public Column getRateColumn(Column mconc) {
        double[] c = mconc.getData();
        double[] vr = new double[this.nreaction];
        int ireac = 0;
        while (ireac < this.nreaction) {
            int[] si = this.reactantIndices[ireac];
            double r = this.rates[ireac];
            r *= c[si[0]];
            if (si[1] >= 0) {
                r *= c[si[1]];
            }
            vr[ireac] = r;
            ++ireac;
        }
        return new Column(vr);
    }

    public Matrix getProductionMatrix() {
        if (this.productionMatrix == null) {
            double[][] a = new double[this.nspecie][this.nreaction];
            int ireac = 0;
            while (ireac < this.nreaction) {
                int[] si = this.reactantIndices[ireac];
                double[] dArray = a[si[0]];
                int n = ireac;
                dArray[n] = dArray[n] - 1.0;
                if (si[1] >= 0) {
                    double[] dArray2 = a[si[1]];
                    int n2 = ireac;
                    dArray2[n2] = dArray2[n2] - 1.0;
                }
                int[] pi = this.productIndices[ireac];
                double[] dArray3 = a[pi[0]];
                int n3 = ireac;
                dArray3[n3] = dArray3[n3] + 1.0;
                if (pi[1] >= 0) {
                    double[] dArray4 = a[pi[1]];
                    int n4 = ireac;
                    dArray4[n4] = dArray4[n4] + 1.0;
                }
                ++ireac;
            }
            this.productionMatrix = new Matrix(a);
        }
        return this.productionMatrix;
    }

    public Column getProductionColumn(Column mconc) {
        double[] c = mconc.getData();
        double[] vr = new double[this.nspecie];
        int ireac = 0;
        while (ireac < this.nreaction) {
            int[] si = this.reactantIndices[ireac];
            int[] pi = this.productIndices[ireac];
            double r = this.rates[ireac];
            r *= c[si[0]];
            if (si[1] >= 0) {
                r *= c[si[1]];
            }
            int n = si[0];
            vr[n] = vr[n] - r;
            if (si[1] >= 0) {
                int n2 = si[1];
                vr[n2] = vr[n2] - r;
            }
            int n3 = pi[0];
            vr[n3] = vr[n3] + r;
            if (pi[1] >= 0) {
                int n4 = pi[1];
                vr[n4] = vr[n4] + r;
            }
            ++ireac;
        }
        return new Column(vr);
    }

    public Matrix getIncrementRateMatrix(Column mconc) {
        double[][] d = new double[this.nspecie][this.nspecie];
        double[] c = mconc.getData();
        int ireac = 0;
        while (ireac < this.nreaction) {
            int[] si = this.reactantIndices[ireac];
            int[] pi = this.productIndices[ireac];
            double r = this.rates[ireac];
            if (si[1] >= 0) {
                r *= c[si[1]];
            }
            int isrc = si[0];
            double[] dArray = d[si[0]];
            int n = isrc;
            dArray[n] = dArray[n] - r;
            if (si[1] >= 0) {
                double[] dArray2 = d[si[1]];
                int n2 = isrc;
                dArray2[n2] = dArray2[n2] - r;
            }
            double[] dArray3 = d[pi[0]];
            int n3 = isrc;
            dArray3[n3] = dArray3[n3] + r;
            if (pi[1] >= 0) {
                double[] dArray4 = d[pi[1]];
                int n4 = isrc;
                dArray4[n4] = dArray4[n4] + r;
            }
            if (si[1] >= 0) {
                r = this.rates[ireac];
                isrc = si[1];
                double[] dArray5 = d[si[0]];
                int n5 = isrc;
                dArray5[n5] = dArray5[n5] - (r *= c[si[0]]);
                if (si[1] >= 0) {
                    double[] dArray6 = d[si[1]];
                    int n6 = isrc;
                    dArray6[n6] = dArray6[n6] - r;
                }
                double[] dArray7 = d[pi[0]];
                int n7 = isrc;
                dArray7[n7] = dArray7[n7] + r;
                if (pi[1] >= 0) {
                    double[] dArray8 = d[pi[1]];
                    int n8 = isrc;
                    dArray8[n8] = dArray8[n8] + r;
                }
            }
            ++ireac;
        }
        return new Matrix(d);
    }

    public final Column stepResiduals(Column vc, Column vdc, double dt) {
        Column vctot = vc.plus(vdc);
        double[] ctot = vctot.getData();
        Column vret = vdc.copy();
        double[] ret = vdc.getData();
        int ireac = 0;
        while (ireac < this.nreaction) {
            int[] srcIdx = this.reactantIndices[ireac];
            int[] prodIdx = this.productIndices[ireac];
            double r = this.rates[ireac];
            r *= ctot[srcIdx[0]];
            if (srcIdx[1] >= 0) {
                r *= ctot[srcIdx[1]];
            }
            int n = srcIdx[0];
            ret[n] = ret[n] + r;
            if (srcIdx[1] >= 0) {
                int n2 = srcIdx[1];
                ret[n2] = ret[n2] + r;
            }
            int n3 = prodIdx[0];
            ret[n3] = ret[n3] - r;
            if (prodIdx[1] >= 0) {
                int n4 = prodIdx[1];
                ret[n4] = ret[n4] + r;
            }
            ++ireac;
        }
        return vret;
    }

    public int getNReaction() {
        return this.nreaction;
    }

    public double[] getRates() {
        return this.rates;
    }

    public int[][] getReactantIndices() {
        return this.reactantIndices;
    }

    public int[][] getProductIndices() {
        return this.productIndices;
    }

    public int[][] getReactantStochiometry() {
        return this.reactantStochiometry;
    }

    public int[][] getProductStochiometry() {
        return this.productStochiometry;
    }

    public int getSpecieIndex(String specieID) {
        String[] sa = this.getSpeciesIDs();
        int iret = -1;
        int i = 0;
        while (i < this.nspecie) {
            if (sa[i].equals(specieID)) {
                iret = i;
                break;
            }
            ++i;
        }
        if (iret < 0) {
            E.error("cant find specie " + specieID + " required for stimulation");
            E.dump("specs", sa);
        }
        return iret;
    }
}

