/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.morph;

import java.util.ArrayList;
import org.textensor.report.E;
import org.textensor.stochdiff.geom.GRotation;
import org.textensor.stochdiff.geom.Geom;
import org.textensor.stochdiff.geom.Position;
import org.textensor.stochdiff.geom.Translation;
import org.textensor.stochdiff.geom.Vector;
import org.textensor.stochdiff.numeric.morph.TreePoint;
import org.textensor.stochdiff.numeric.morph.VolumeElement;

public class VolumeSlice {
    int nx;
    int ny;
    double boxSize;
    double radius;
    int icenter;
    int jcenter;
    boolean[][] present;
    VolumeElement[][] elements;

    public VolumeSlice(double delta, double r) {
        int n;
        this.boxSize = delta;
        this.radius = r;
        int nr = (int)(r / delta);
        this.nx = n = 1 + 2 * nr;
        this.ny = n;
        this.icenter = nr;
        this.jcenter = nr;
        this.present = new boolean[this.nx][this.ny];
        int nt = 0;
        int nf = 0;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                double dx = (double)(i - this.icenter) * this.boxSize;
                double dy = (double)(j - this.jcenter) * this.boxSize;
                double r2 = dx * dx + dy * dy;
                if (r2 < this.radius * this.radius) {
                    this.present[i][j] = true;
                    ++nt;
                } else {
                    this.present[i][j] = false;
                    ++nf;
                }
                ++j;
            }
            ++i;
        }
    }

    public VolumeElement getElement(int i, int j) {
        return this.elements[i][j];
    }

    public void discFill(Position pa, Position pb, String pointLabel, String regionLabel) {
        double sl = Geom.distanceBetween(pa, pb);
        Translation trans = Geom.translation(Geom.midpoint(pa, pb));
        Vector vab = Geom.fromToVector(pa, pb);
        double theta = Geom.zRotationAngle(Geom.unitY(), vab);
        GRotation rot = Geom.aboutZRotation(theta);
        this.elements = new VolumeElement[this.nx][this.ny];
        double x0 = (double)(-1 * this.icenter) * this.boxSize;
        double y0 = (double)(-1 * this.jcenter) * this.boxSize;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.present[i][j]) {
                    VolumeElement ve;
                    double vcx = x0 + (double)i * this.boxSize;
                    double vcy = y0 + (double)j * this.boxSize;
                    this.elements[i][j] = ve = new VolumeElement();
                    if (regionLabel != null) {
                        ve.setRegion(regionLabel);
                    }
                    ve.setVolume(this.boxSize * this.boxSize * sl);
                    ve.setDeltaZ(this.boxSize);
                    Position cp = Geom.position(vcx, vcy, 0.0);
                    Position pr = rot.getRotatedPosition(cp);
                    Position pc = trans.getTranslated(pr);
                    ve.setCenterPosition(pc.getX(), pc.getY(), pc.getZ());
                    ve.setAlongArea(this.boxSize * sl);
                    ve.setSideArea(this.boxSize * this.boxSize);
                    ve.setTopArea(this.boxSize * sl);
                    Position[] pbdry = new Position[]{Geom.position(vcx - 0.5 * this.boxSize, -0.5 * sl, vcy), Geom.position(vcx - 0.5 * this.boxSize, 0.5 * sl, vcy), Geom.position(vcx + 0.5 * this.boxSize, 0.5 * sl, vcy), Geom.position(vcx + 0.5 * this.boxSize, -0.5 * sl, vcy)};
                    int ib = 0;
                    while (ib < pbdry.length) {
                        pbdry[ib] = trans.getTranslated(rot.getRotatedPosition(pbdry[ib]));
                        ++ib;
                    }
                    ve.setBoundary(pbdry);
                    if (regionLabel != null) {
                        ve.setRegion(regionLabel);
                    }
                    boolean surf = false;
                    double hb = 0.5 * this.boxSize;
                    Position[] psb = new Position[4];
                    if (i == 0 || !this.present[i - 1][j]) {
                        surf = true;
                        double xb = vcx + -0.5 * this.boxSize;
                        psb[0] = Geom.position(xb, -0.5 * sl, vcy - hb);
                        psb[1] = Geom.position(xb, -0.5 * sl, vcy + hb);
                        psb[2] = Geom.position(xb, 0.5 * sl, vcy + hb);
                        psb[3] = Geom.position(xb, 0.5 * sl, vcy - hb);
                    } else if (i == this.nx - 1 || !this.present[i + 1][j]) {
                        surf = true;
                        double xb = vcx + 0.5 * this.boxSize;
                        psb[0] = Geom.position(xb, -0.5 * sl, vcy + hb);
                        psb[1] = Geom.position(xb, -0.5 * sl, vcy - hb);
                        psb[2] = Geom.position(xb, 0.5 * sl, vcy - hb);
                        psb[3] = Geom.position(xb, 0.5 * sl, vcy + hb);
                    } else if (j == 0 || !this.present[i][j - 1]) {
                        surf = true;
                        double yb = vcy - 0.5 * this.boxSize;
                        psb[0] = Geom.position(vcx + hb, -0.5 * sl, yb);
                        psb[1] = Geom.position(vcx - hb, -0.5 * sl, yb);
                        psb[2] = Geom.position(vcx - hb, 0.5 * sl, yb);
                        psb[3] = Geom.position(vcx + hb, 0.5 * sl, yb);
                    } else if (j == this.ny - 1 || !this.present[i][j + 1]) {
                        surf = true;
                        double yb = vcy + 0.5 * this.boxSize;
                        psb[0] = Geom.position(vcx - hb, -0.5 * sl, yb);
                        psb[1] = Geom.position(vcx + hb, -0.5 * sl, yb);
                        psb[2] = Geom.position(vcx + hb, 0.5 * sl, yb);
                        psb[3] = Geom.position(vcx - hb, 0.5 * sl, yb);
                    }
                    if (surf) {
                        ve.setSubmembrane();
                        int ib2 = 0;
                        while (ib2 < psb.length) {
                            psb[ib2] = trans.getTranslated(rot.getRotatedPosition(psb[ib2]));
                            ++ib2;
                        }
                        ve.setSurfaceBoundary(psb);
                        ve.setExposedArea(sl * this.boxSize);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (pointLabel != null) {
            this.elements[this.icenter][this.icenter].setLabel(pointLabel);
        }
        this.neighborize();
    }

    public void neighborize() {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                VolumeElement v = this.elements[i][j];
                VolumeElement vx = null;
                VolumeElement vy = null;
                if (i + 1 < this.nx) {
                    vx = this.elements[i + 1][j];
                }
                if (j + 1 < this.ny) {
                    vy = this.elements[i][j + 1];
                }
                if (v != null && vx != null) {
                    v.coupleTo(vx, v.getAlongArea());
                }
                if (v != null && vy != null) {
                    v.coupleTo(vy, v.getTopArea());
                }
                ++j;
            }
            ++i;
        }
    }

    public void planeConnect(VolumeSlice tgt) {
        if (tgt.nx == this.nx && tgt.ny == this.ny) {
            int i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    VolumeElement va = this.getElement(i, j);
                    VolumeElement vb = tgt.getElement(i, j);
                    if (va != null && vb != null) {
                        va.coupleTo(vb, va.getSideArea());
                    }
                    ++j;
                }
                ++i;
            }
        } else if (tgt.nx < this.nx) {
            tgt.planeConnectUp(this);
        } else {
            this.planeConnectUp(tgt);
        }
    }

    private void planeConnectUp(VolumeSlice tgt) {
        int io = (tgt.nx - this.nx) / 2;
        int jo = (tgt.ny - this.ny) / 2;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                VolumeElement va = this.getElement(i, j);
                VolumeElement vb = tgt.getElement(io + i, jo + j);
                if (va != null && vb != null) {
                    va.coupleTo(vb, va.getSideArea());
                }
                ++j;
            }
            ++i;
        }
    }

    public ArrayList<VolumeElement> getElements() {
        ArrayList<VolumeElement> ave = new ArrayList<VolumeElement>();
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                VolumeElement ve = this.getElement(i, j);
                if (ve != null) {
                    ave.add(ve);
                }
                ++j;
            }
            ++i;
        }
        return ave;
    }

    public void subPlaneConnect(TreePoint tp, TreePoint tpn, VolumeSlice vg, double pborel) {
        double pbo = 1.0 * (pborel - (this.radius - vg.radius));
        E.info("connecting to a subplane size " + vg.radius + " np=" + vg.nx + " offset by " + pbo);
        E.info("boxes and dims: " + this.boxSize + ", " + vg.boxSize + " " + this.nx + "," + vg.nx + "  rads " + this.radius + ", " + vg.radius);
        double xtg0 = (double)(-1 * vg.icenter) * vg.boxSize;
        double ytg0 = (double)(-1 * vg.jcenter) * vg.boxSize + pbo;
        int ncpld = 0;
        int itg = 0;
        while (itg < vg.nx) {
            int jtg = 0;
            while (jtg < vg.ny) {
                if (vg.hasElement(itg, jtg)) {
                    double cxtg = xtg0 + (double)itg * vg.boxSize;
                    double cytg = ytg0 + (double)jtg * vg.boxSize;
                    int ilmin = this.getIBox(cxtg);
                    int jlmin = this.getJBox(cytg);
                    int ilmax = this.getIBox(cxtg + vg.boxSize);
                    int jlmax = this.getJBox(cytg + vg.boxSize);
                    int il = ilmin;
                    while (il <= ilmax) {
                        int jl = jlmin;
                        while (jl <= jlmax) {
                            double ovlp;
                            if (this.hasElement(il, jl) && (ovlp = this.overlapFactor(this.getX(il), this.getY(il), this.boxSize, cxtg, cytg, vg.boxSize)) > 0.0) {
                                this.getElement(il, jl).coupleTo(vg.getElement(itg, jtg), ovlp * this.boxSize * this.boxSize);
                                ++ncpld;
                            }
                            ++jl;
                        }
                        ++il;
                    }
                }
                ++jtg;
            }
            ++itg;
        }
        E.info("coupled " + ncpld + " elements ");
    }

    private double overlapFactor(double mex, double mey, double med, double tgtx, double tgty, double tgtd) {
        double fx = this.ovlp1D(mex, med, tgtx, tgtd);
        double fy = this.ovlp1D(mey, med, tgty, tgtd);
        double ret = fx * fy;
        return ret;
    }

    private double ovlp1D(double mex, double med, double tgtx, double tgtd) {
        double ret = 0.0;
        ret = mex <= tgtx ? (mex + med > tgtx + tgtd ? tgtd : mex + med - tgtx) : (mex + med > tgtx + tgtd ? med : tgtx + tgtd - mex);
        return ret / med;
    }

    public double getX(int i) {
        double ret = ((double)(-this.nx) / 2.0 + (double)i) * this.boxSize;
        return ret;
    }

    public double getY(int j) {
        double ret = ((double)(-this.ny) / 2.0 + (double)j) * this.boxSize;
        return ret;
    }

    public boolean hasElement(int i, int j) {
        boolean ret = false;
        if (i >= 0 && i < this.nx && j >= 0 && j < this.ny) {
            ret = this.present[i][j];
        }
        return ret;
    }

    public int getIBox(double x) {
        int ret = (int)(x / this.boxSize + (double)this.nx / 2.0);
        return ret;
    }

    public int getJBox(double y) {
        int ret = (int)(y / this.boxSize + (double)this.ny / 2.0);
        return ret;
    }
}

