/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.pool;

import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.BaseCalc;
import org.textensor.stochdiff.numeric.chem.ReactionTable;
import org.textensor.stochdiff.numeric.math.Column;

public abstract class DeterministicPoolCalc
extends BaseCalc {
    Column mconc;
    ReactionTable rtab;
    double dt;
    double time;

    public DeterministicPoolCalc(SDRun sdm) {
        super(sdm);
    }

    public final void init() {
        this.rtab = this.getReactionTable();
        this.rtab.print();
        this.mconc = new Column(this.getNanoMolarConcentrations());
        this.dt = this.sdRun.fixedStepDt;
    }

    @Override
    public final void run() {
        this.init();
        this.mconc.print();
        this.time = 0.0;
        double runtime = this.sdRun.runtime;
        this.dpcInit();
        while (this.time < runtime) {
            this.time += this.advance();
        }
    }

    public void dpcInit() {
    }

    public abstract double advance();
}

