/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.reduce;

import java.io.File;
import java.util.ArrayList;
import org.catacomb.util.FileUtil;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.FloatValued;
import org.textensor.stochdiff.inter.SDState;
import org.textensor.stochdiff.model.InitialConditions;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.StaticCalc;
import org.textensor.stochdiff.numeric.math.Matrix;

public class Reducer {
    SDRun sdr;
    SDState sds;
    StaticCalc staticCalc;
    InitialConditions icon;
    ArrayList<FloatValued> afv;
    int nv;
    double[] vols;
    int nel;
    int nspec;
    double[][] ctgt;

    public Reducer(SDRun sdModel, SDState sdState) {
        this.sdr = sdModel;
        this.sds = sdState;
    }

    public void reduce() {
        E.info("Starting reduce");
        this.icon = this.sdr.initialConditions;
        this.afv = this.icon.getFloatValuedElements();
        this.nv = this.afv.size();
        double x0 = 10.0;
        double dx = 0.1;
        E.info("The template provides " + this.nv + " accessible concentration values");
        this.staticCalc = new StaticCalc(this.sdr);
        this.staticCalc.init();
        this.vols = this.staticCalc.getVolumes();
        this.nspec = this.staticCalc.getNSpec();
        this.nel = this.staticCalc.getNel();
        this.ctgt = this.sds.getConc2();
        int j = 0;
        while (j < this.nv) {
            this.afv.get(j).setValue(x0);
            ++j;
        }
        double[] c0 = this.staticCalc.getConcentrations();
        int nconc = c0.length;
        E.info("The template provides " + this.nv + " variable quantities");
        E.info("After discretization there are " + nconc + " state variables arising from " + this.nspec + " species in " + this.nel + " elements");
        double[][] bm = new double[nconc][this.nv];
        int i = 0;
        while (i < this.nv) {
            int j2 = 0;
            while (j2 < this.nv) {
                this.afv.get(j2).setValue(x0);
                ++j2;
            }
            this.afv.get(i).setValue(x0 + dx);
            double[] cwk = this.staticCalc.getConcentrations();
            int k = 0;
            while (k < nconc) {
                bm[k][i] = (cwk[k] - c0[k]) / dx;
                ++k;
            }
            ++i;
        }
        double[] tgtconc = this.sds.getConc1();
        Matrix b = new Matrix(bm);
        Matrix bt = b.transpose();
        Matrix mtgtconc = new Matrix(Matrix.COLUMN, tgtconc);
        Matrix btb = bt.times(b);
        Matrix btbi = btb.inverse();
        Matrix res = btbi.times(bt.times(mtgtconc));
        double[] fit = res.getColumn(0);
        String[] spres = this.icon.getTotalPreserved();
        if (spres.length > 0) {
            int ncn = spres.length;
            int[] ispeccon = this.staticCalc.getSpecieIndexes(spres);
            String ss = "";
            int i2 = 0;
            while (i2 < ncn) {
                ss = String.valueOf(ss) + " " + spres[i2] + "(" + ispeccon[i2] + ") ";
                ++i2;
            }
            E.info(" " + ncn + " constraint(s) on totals for species " + ss);
            double[][] q = new double[ncn][this.nv];
            double[] qtgt = new double[ncn];
            int icn = 0;
            while (icn < ncn) {
                int ispec = ispeccon[icn];
                int iel = 0;
                while (iel < this.nel) {
                    int i3 = 0;
                    while (i3 < this.nv) {
                        double[] dArray = q[icn];
                        int n = i3;
                        dArray[n] = dArray[n] + this.vols[iel] * bm[iel * this.nspec + ispec][i3];
                        ++i3;
                    }
                    int n = icn;
                    qtgt[n] = qtgt[n] + this.vols[iel] * this.ctgt[iel][ispec];
                    ++iel;
                }
                ++icn;
            }
            Matrix mq = new Matrix(q);
            Matrix mr = new Matrix(Matrix.COLUMN, fit);
            Matrix mc = new Matrix(Matrix.COLUMN, qtgt);
            Matrix wk1 = mq.times(mr).subtract(mc);
            Matrix wk2 = mq.times(btbi).times(mq.transpose());
            Matrix wk3 = mq.transpose().times(wk2.inverse());
            Matrix wk4 = btbi.times(wk3).times(wk1);
            Matrix mrcon = mr.subtract(wk4);
            fit = mrcon.getColumnData();
        }
        this.showFit(fit, b.times(new Matrix(Matrix.COLUMN, fit)).getColumnData());
        int j3 = 0;
        while (j3 < this.nv) {
            this.afv.get(j3).setValue(fit[j3]);
            ++j3;
        }
        String stxt = this.icon.xmlSerialize();
        File fout = new File("reduce-fit.xml");
        FileUtil.writeStringToFile(stxt, fout);
        E.info("New initial conditions have been written to " + fout);
        E.info("Best fit xml is:\n " + stxt);
    }

    public void showFit(double[] newvars, double[] mcdat) {
        int j = 0;
        while (j < this.nv) {
            this.afv.get(j).setValue(newvars[j]);
            ++j;
        }
        double[][] cfit = this.staticCalc.getElementConcentrations();
        E.info("Average concentrations by species: ");
        int ispec = 0;
        while (ispec < this.nspec) {
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            double vtot = 0.0;
            int iel = 0;
            while (iel < this.nel) {
                a += this.vols[iel] * this.ctgt[iel][ispec];
                b += this.vols[iel] * cfit[iel][ispec];
                c += this.vols[iel] * mcdat[iel * this.nspec + ispec];
                vtot += this.vols[iel];
                ++iel;
            }
            E.info("    species " + ispec + " target=" + (a /= vtot) + "  fit=" + (b /= vtot));
            ++ispec;
        }
    }

    public void printconc(double[][] dat) {
        int i = 0;
        while (i < this.nel) {
            String sl = "elt " + i + " ";
            int j = 0;
            while (j < this.nspec) {
                sl = String.valueOf(sl) + String.format("%12.3f", dat[i][j]) + " ";
                ++j;
            }
            E.info(sl);
            ++i;
        }
    }
}

