/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.inter.XMLContainer;
import org.textensor.xml.Attribute;
import org.textensor.xml.Narrower;

public class ReflectionInstantiator {
    ArrayList search = new ArrayList();
    int npkg = 0;
    String[] pkgs = new String[100];
    String wkpkg;

    public ReflectionInstantiator() {
    }

    public ReflectionInstantiator(String path) {
        this();
        this.addSearchPackage(path);
    }

    public void addSearchPackage(String s) {
        this.wkpkg = s;
        this.pkgs[this.npkg++] = s;
    }

    public void appendContent(Object obj, String s) {
        if (obj instanceof XMLContainer) {
            ((XMLContainer)obj).appendContent(s);
        } else {
            E.error(" - reflection instantiator doesn't do appendContent on " + obj + "(" + obj.getClass() + ") while trying to append " + s);
        }
    }

    public void checkAddPackage(Object oret) {
        String scl = oret.getClass().getName();
        if (scl.startsWith("java")) {
            return;
        }
        int ild = scl.lastIndexOf(".");
        String pkg = scl.substring(0, ild);
        if (!pkg.equals(this.wkpkg)) {
            boolean got = false;
            int i = 0;
            while (i < this.npkg) {
                if (this.pkgs[i].equals(pkg)) {
                    got = true;
                    break;
                }
                ++i;
            }
            if (!got) {
                this.pkgs[this.npkg++] = pkg;
            }
        }
    }

    public Object newInstance(String scl) {
        Object oret = null;
        Class<?> c = null;
        if (scl.indexOf(":") > 0) {
            scl = scl.substring(0, scl.indexOf(":"));
        }
        if (scl.indexOf(".") > 0) {
            try {
                c = Class.forName(scl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == null) {
            int i = 0;
            while (i < this.npkg && c == null) {
                try {
                    c = Class.forName(String.valueOf(this.pkgs[i]) + "." + scl);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (c == null) {
            E.error("cant instantiate (class not found): " + scl);
            E.reportCached();
            int i = 0;
            while (i < this.npkg) {
                E.info("tried package " + this.pkgs[i]);
                ++i;
            }
            if (scl.endsWith("ing")) {
                new Exception().printStackTrace();
            }
        } else {
            int imod = c.getModifiers();
            if (Modifier.isAbstract(imod)) {
                E.error("cant instantiatie " + c + ":  it is an abstract class");
            } else {
                try {
                    oret = c.newInstance();
                }
                catch (Exception e) {
                    E.error(" " + e + " instantiating " + c);
                    e.printStackTrace();
                }
            }
        }
        if (oret != null) {
            this.checkAddPackage(oret);
        }
        return oret;
    }

    public Object getField(Object ob, String fnm) {
        Object ret = null;
        boolean hasField = false;
        Field[] flds = ob.getClass().getFields();
        int i = 0;
        while (i < flds.length) {
            if (flds[i].getName().equals(fnm)) {
                hasField = true;
                break;
            }
            ++i;
        }
        if (hasField) {
            try {
                Field f = ob.getClass().getField(fnm);
                Class<?> fcl = f.getType();
                ret = fcl.equals(String[].class) ? new String[]{} : (fcl.isArray() ? new ArrayList() : f.get(ob));
                if (ret == null) {
                    Class<?> cl = f.getType();
                    ret = cl.newInstance();
                }
            }
            catch (Exception e) {
                E.error("cant get field " + fnm + " on " + ob + " " + "excception= " + e);
            }
        }
        if (!hasField) {
            boolean cfr_ignored_0 = ob instanceof ArrayList;
        }
        return ret;
    }

    public Object getChildObject(Object parent, String name, Attribute[] atta) {
        Object child = null;
        if (parent != null) {
            this.checkAddPackage(parent);
        }
        if (atta == null) {
            atta = new Attribute[]{};
        }
        String classname = null;
        int i = 0;
        while (i < atta.length) {
            Attribute att = atta[i];
            String attName = att.getName();
            String attValue = att.getValue();
            if (attName.equals("package")) {
                StringTokenizer stok = new StringTokenizer(attValue, ", ");
                while (stok.hasMoreTokens()) {
                    this.addSearchPackage(stok.nextToken());
                }
            } else if (attName.equals("archive-hash")) {
                E.debugError("xmlreader found reference to archive file  but has no importContext to retrieve object");
            } else if (attName.equals("class")) {
                classname = attValue;
            }
            ++i;
        }
        if (child == null && classname != null) {
            child = this.newInstance(classname);
        }
        if (child == null && parent != null) {
            child = this.getField(parent, name);
        }
        if (child == null) {
            child = this.newInstance(name);
        }
        if (child == null) {
            E.warning("ReflectionInstantiator failed to get field " + name + " on " + parent + " " + (parent != null ? parent.getClass().toString() : ""));
        }
        return child;
    }

    public void applyAttributes(Object target, Attribute[] atta) {
        int i = 0;
        while (i < atta.length) {
            Attribute att = atta[i];
            this.setAttributeField(target, att.getName(), att.getValue());
            ++i;
        }
    }

    public boolean setAttributeField(Object target, String name, String arg) {
        boolean bret = false;
        if (!(name.equals("class") || name.equals("package") || name.equals("provides") || name.equals("archive-hash"))) {
            bret = this.setField(target, name, arg);
        }
        return bret;
    }

    public boolean setField(Object ob, String sf, Object arg) {
        if (ob == null) {
            E.error("null parent for " + sf + " (" + arg + ")");
            return true;
        }
        if (arg == null) {
            E.error("reflection instantiator has null arg setting " + sf + " in " + ob);
            return true;
        }
        if (arg.equals(ob)) {
            E.error("ReflectionInstantiator setField: the child is the same as the parent " + ob);
            return true;
        }
        int icolon = sf.indexOf(":");
        if (icolon >= 0) {
            sf = String.valueOf(sf.substring(0, icolon)) + "_" + sf.substring(icolon + 1, sf.length());
        }
        boolean ok = false;
        Class<?> c = ob.getClass();
        Field f = null;
        try {
            f = c.getField(sf);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (f == null) {
            if (ob instanceof ArrayList) {
                ((ArrayList)ob).add(arg);
                ok = true;
            } else if (ob instanceof AddableTo && this.nonPrimitive(arg)) {
                ((AddableTo)ob).add(arg);
                ok = true;
            } else {
                E.oneLineWarning("no such field " + sf + " on " + ob + "while settting " + arg);
                E.reportCached();
                ok = false;
            }
        } else {
            if (arg instanceof ArrayList && ((ArrayList)arg).size() == 1) {
                for (Object sub : (ArrayList)arg) {
                    arg = sub;
                }
            }
            try {
                Class<?> ftyp = f.getType();
                if (ftyp == String.class && arg instanceof String) {
                    f.set(ob, arg);
                } else if (ftyp == Double.TYPE && arg instanceof String) {
                    Double d = new Double((String)arg);
                    f.set(ob, d);
                } else if (ftyp == Integer.TYPE && arg instanceof String) {
                    Integer ig = new Integer((String)arg);
                    f.set(ob, ig);
                } else if (ftyp == Double.TYPE && arg instanceof Double) {
                    f.set(ob, arg);
                } else if (ftyp == Boolean.TYPE && arg instanceof Boolean) {
                    f.set(ob, arg);
                } else if (ftyp == Integer.TYPE && arg instanceof Integer) {
                    f.set(ob, arg);
                } else if (f.getType().isArray() && arg instanceof ArrayList) {
                    this.setArrayField(ob, f, (ArrayList)arg);
                } else {
                    Object onarg = Narrower.narrow(ftyp.getName(), arg);
                    if (onarg != null) {
                        f.set(ob, onarg);
                    } else {
                        f.set(ob, arg);
                    }
                }
                ok = true;
            }
            catch (Exception e) {
                ok = false;
                E.error(" cant set field " + sf + " in " + ob + " from value " + arg + " " + e);
            }
        }
        return ok;
    }

    public void setArrayField(Object obj, Field fld, ArrayList vals) {
        E.missing();
        System.out.println("setting array field of " + vals.size() + " in " + obj + " fnm=" + fld.getName());
    }

    private boolean nonPrimitive(Object arg) {
        boolean ret = true;
        if (arg instanceof String || arg instanceof Integer || arg instanceof Double) {
            ret = false;
        }
        return ret;
    }

    public void setIntFromStatic(Object ret, String id, String sv) {
        String svu = sv.toUpperCase();
        Object obj = this.getField(ret, svu);
        if (obj instanceof Integer) {
            this.setField(ret, id, obj);
        } else {
            E.error("need an Integer, not  " + obj);
        }
    }
}

