/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.image.BufferedImage;
import java.io.File;
import org.catacomb.dataview.DataviewController;
import org.catacomb.dataview.gui.FramePlayer;
import org.catacomb.druid.gui.edit.DruButton;
import org.catacomb.druid.gui.edit.DruSlider;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.GUISourced;
import org.catacomb.movie.gif.AnimatedGifEncoder;
import org.catacomb.numeric.data.DataExtractor;
import org.catacomb.report.E;
import org.catacomb.util.AWTUtil;

public class FrameController
implements Controller,
GUISourced {
    DruSlider frameSlider;
    String sourcePath;
    String displayPath;
    int[] indexes;
    String[] displayValues;
    DataviewController dataviewController;
    DataExtractor dataExtractor;
    double speed = 1.0;
    int shownFrame;
    FramePlayer framePlayer;
    boolean isPaused;
    DruButton pauseButton;

    public FrameController(String src, String dply) {
        this.sourcePath = src;
        this.displayPath = dply;
    }

    public void setDataviewController(DataviewController dvc) {
        this.dataviewController = dvc;
    }

    public void setDataSource(DataExtractor dex) {
        this.dataExtractor = dex;
        if (this.frameSlider != null) {
            this.applyData();
        }
    }

    @Override
    public void attached() {
    }

    public void markNeeded() {
        this.dataExtractor.mark(this.sourcePath);
        this.dataExtractor.mark(this.displayPath);
    }

    public void applyData() {
        this.indexes = this.dataExtractor.getIntVector(this.sourcePath);
        double[] adv = this.dataExtractor.getVector(this.displayPath);
        this.displayValues = new String[this.indexes.length];
        int i = 0;
        while (i < this.indexes.length) {
            this.displayValues[i] = "" + adv[this.indexes[i]];
            ++i;
        }
        this.frameSlider.setValues(this.displayValues);
        this.showFrame(0);
    }

    public void showFrame(int iframein) {
        int iframe = iframein;
        if (iframe < 0) {
            iframe = 0;
        }
        if (iframe >= this.indexes.length) {
            iframe = this.indexes.length - 1;
        }
        this.dataviewController.showFrame(this.indexes[iframe]);
        if (this.frameSlider != null) {
            this.frameSlider.showValue(iframe);
        }
        this.shownFrame = iframe;
    }

    public String getGUITargets() {
        return "Slider PauseButton";
    }

    @Override
    public String getGUISources() {
        return "*";
    }

    public void show(Object obj) {
    }

    public void setSlider(DruSlider dfs) {
        this.frameSlider = dfs;
        if (this.dataExtractor != null) {
            this.applyData();
        }
    }

    public void setPauseButton(DruButton db) {
        this.pauseButton = db;
    }

    public void sliderMoved() {
        int ival = this.frameSlider.getValue();
        this.showFrame(ival);
    }

    public void rewind() {
        this.stop();
        this.showFrame(0);
    }

    public void pause() {
        if (this.isPaused) {
            this.dePause();
            this.start();
        } else {
            this.rePause();
            this.stop();
        }
    }

    public void dePause() {
        this.isPaused = false;
        this.pauseButton.setLabelText(" pause ");
    }

    private void rePause() {
        this.isPaused = true;
        this.pauseButton.setLabelText("resume");
    }

    public void play() {
        this.stop();
        this.rewind();
        this.start();
        this.dePause();
    }

    private void start() {
        if (this.indexes != null) {
            this.framePlayer = null;
            this.framePlayer.start();
        }
    }

    public void stop() {
        if (this.framePlayer != null) {
            this.framePlayer.stop();
        }
    }

    public void faster() {
        this.speed *= 1.3;
    }

    public void slower() {
        this.speed /= 1.3;
    }

    public boolean canAdvance() {
        return this.indexes != null && this.shownFrame < this.indexes.length - 1;
    }

    public void advance() {
        this.showFrame(this.shownFrame + 1);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void record() {
        E.missing();
    }

    public void miniRecord() {
        E.missing();
    }

    public void makeMovie(File f) {
        this.makeAnimatedGif(f);
    }

    public void makeThumbnailMovie(File f) {
        this.makeMiniAnimatedGif(f, 160, 160);
    }

    public void makeAnimatedGif(File f) {
        this.stop();
        this.rewind();
        AnimatedGifEncoder enc = new AnimatedGifEncoder();
        enc.start(f);
        enc.setDelay(160);
        int ifr = 0;
        E.info("animated gif - frame " + ifr);
        enc.addFrame(this.dataviewController.getBufferedImage(1));
        while (this.canAdvance()) {
            this.advance();
            E.info("animated gif - frame " + ++ifr);
            enc.addFrame(this.dataviewController.getBufferedImage(1));
        }
        enc.finish();
    }

    public void makeMiniAnimatedGif(File f, int wsclin, int hsclin) {
        int wscl = wsclin;
        int hscl = hsclin;
        this.stop();
        this.rewind();
        AnimatedGifEncoder enc = new AnimatedGifEncoder();
        enc.start(f);
        enc.setDelay(200);
        int nfr = this.indexes.length;
        int stepsize = nfr / 10;
        if (stepsize < 1) {
            stepsize = 1;
        }
        int ifr = 0;
        int ithick = 1;
        while (this.canAdvance()) {
            E.info("animated gif - frame " + ifr);
            BufferedImage bim = this.dataviewController.getBufferedImage(ithick);
            if (ifr == 0) {
                double fo;
                int hf;
                int wf = bim.getWidth();
                double ff = (float)wf / (float)(hf = bim.getHeight());
                if (ff > (fo = (double)((float)wscl / (float)hscl))) {
                    hscl = (int)((double)wscl / ff);
                } else {
                    wscl = (int)((double)hscl * ff);
                }
                ithick = (wf + wscl / 2) / wscl;
                bim = this.dataviewController.getBufferedImage(ithick);
            }
            BufferedImage bufim = AWTUtil.getScaledBufferedImage(bim, wscl, hscl);
            enc.addFrame(bufim);
            ++ifr;
            int i = 0;
            while (i < stepsize) {
                if (this.canAdvance()) {
                    this.advance();
                }
                ++i;
            }
        }
        enc.finish();
    }
}

