/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.read;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.catacomb.dataview.read.ContentReader;
import org.catacomb.dataview.read.Importer;
import org.catacomb.dataview.read.JarImportContext;
import org.catacomb.report.E;
import org.catacomb.serial.jar.CustomJar;

public class CustomJarReader {
    HashMap<String, Object> itemHM;
    HashMap<String, byte[]> rawHM;
    JarImportContext jarImportContext;

    public CustomJarReader(byte[] ba, JarImportContext jctx) {
        this.jarImportContext = jctx;
        this.readAll(ba);
    }

    public void readAll(byte[] bytes) {
        this.rawHM = new HashMap();
        this.itemHM = new HashMap();
        CustomJar.naturalize(bytes);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ZipInputStream zis = new ZipInputStream(bais);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                byte[] buffer = this.readBytes(zis);
                if (CustomJar.isMetaName(name)) {
                    String s = new String(buffer);
                    this.itemHM.put(name, s);
                } else {
                    this.rawHM.put(name, buffer);
                }
                entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception ex) {
            E.error("zip read exception " + ex);
            ex.printStackTrace();
        }
    }

    public Object getRelative(String name) {
        Object ret = null;
        if (this.itemHM.containsKey(name)) {
            ret = this.itemHM.get(name);
        } else if (this.rawHM.containsKey(name)) {
            byte[] bytes = this.rawHM.get(name);
            ContentReader cr = Importer.getReader(bytes, this.jarImportContext);
            ret = cr.getMain();
            this.itemHM.put(name, ret);
        }
        return ret;
    }

    private byte[] readBytes(InputStream ins) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bb = new byte[4096];
        int nread = ins.read(bb);
        while (nread > 0) {
            baos.write(bb, 0, nread);
            nread = ins.read(bb);
        }
        return baos.toByteArray();
    }

    public Object getMain() {
        Object ret = null;
        String sn = CustomJar.getMetaMain();
        if (this.itemHM.containsKey(sn)) {
            Object om = this.itemHM.get(sn);
            if (om instanceof String) {
                String mainname = (String)om;
                if (this.hasRelative(mainname)) {
                    ret = this.getRelative(mainname);
                }
            } else {
                E.error("main name not a string?");
            }
        }
        if (ret == null) {
            E.warning("no main objhect in custom jar - mainname");
        }
        return ret;
    }

    public boolean hasRelative(String name) {
        return this.itemHM.containsKey(name) || this.rawHM.containsKey(name);
    }
}

