/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import java.util.ArrayList;
import org.catacomb.druid.blocks.BaseEffect;
import org.catacomb.druid.blocks.Option;
import org.catacomb.druid.blocks.Panel;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.edit.DruChoice;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.report.E;

public class Choice
extends Panel
implements AddableTo {
    public String label;
    public String store;
    public String action;
    public String options;
    public String labels;
    public String from;
    public int autoSelect;
    public boolean required;
    public String autoset;
    private ArrayList<Option> optionsAL;
    public ArrayList<BaseEffect> effects;

    public Choice() {
        this.autoSelect = -1;
    }

    public Choice(String slab) {
        this.action = this.label = slab;
        this.autoSelect = -1;
    }

    @Override
    public void add(Object obj) {
        if (obj instanceof Option) {
            if (this.optionsAL == null) {
                this.optionsAL = new ArrayList();
            }
            this.optionsAL.add((Option)obj);
        } else if (obj instanceof BaseEffect) {
            if (this.effects == null) {
                this.effects = new ArrayList();
            }
            this.effects.add((BaseEffect)obj);
        } else {
            E.error("cant add " + obj);
        }
    }

    @Override
    public DruPanel instantiatePanel() {
        return new DruChoice(this.label, this.action);
    }

    @Override
    public void populatePanel(DruPanel dp, Context ctx, GUIPath gpath) {
        DruChoice drup = (DruChoice)dp;
        String[] sopts = null;
        String[] slabs = null;
        if (this.optionsAL != null) {
            int n = this.optionsAL.size();
            sopts = new String[n];
            slabs = new String[n];
            int i = 0;
            while (i < n) {
                Option opt = this.optionsAL.get(i);
                sopts[i] = opt.label != null ? opt.label : opt.value;
                slabs[i] = opt.label != null ? opt.value : opt.label;
                ++i;
            }
        } else if (this.options != null) {
            String[] sa = this.options.split(",");
            sopts = new String[sa.length];
            slabs = new String[sa.length];
            int i = 0;
            while (i < sa.length) {
                String s;
                sopts[i] = s = sa[i].trim();
                slabs[i] = s;
                ++i;
            }
            if (this.labels != null) {
                String[] sb = this.labels.split(",");
                int i2 = 0;
                while (i2 < sa.length && i2 < sopts.length) {
                    slabs[i2] = sb[i2].trim();
                    ++i2;
                }
            }
        }
        if (sopts != null) {
            drup.setOptions(sopts, slabs);
            if (this.autoSelect >= 0) {
                drup.setAutoSelect(this.autoSelect);
            } else if (this.autoset != null) {
                int i = 0;
                while (i < sopts.length) {
                    if (sopts[i].equals(this.autoset)) {
                        drup.setAutoSelect(i);
                    }
                    ++i;
                }
            }
        }
        if (this.from != null && this.from.length() > 0) {
            ctx.getMarketplace().addConsumer("ChoiceOptions", drup, this.from);
        }
        if (this.effects != null) {
            drup.setEffects(this.realizeEffects(this.effects, ctx, gpath));
        }
    }
}

