/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.catacomb.druid.gui.base.DruActionRelay;
import org.catacomb.druid.gui.base.DruFlowPanel;
import org.catacomb.druid.gui.base.DruLinkHandler;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.edit.DruButton;
import org.catacomb.druid.swing.DHTMLPane;
import org.catacomb.druid.swing.DScrollPane;
import org.catacomb.interlish.structure.Page;
import org.catacomb.interlish.structure.PageDisplay;
import org.catacomb.interlish.structure.PageSupplier;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.xdoc.HTMLPage;
import org.catacomb.xdoc.XdocBase;

public class DruBrowserPanel
extends DruPanel
implements PageDisplay {
    static final long serialVersionUID = 1001L;
    DScrollPane dsp;
    String htmlTemplate;
    DHTMLPane htmlPane;
    DruFlowPanel dlfp;
    DruButton bprevious;
    DruButton bnext;

    public DruBrowserPanel() {
        this.init();
        HTMLPage hpage = new HTMLPage();
        hpage.loadDefault();
        this.showPage(hpage);
    }

    public DruBrowserPanel(String s) {
        this.init();
        HTMLPage hpage = new HTMLPage();
        if (s != null && s.length() > 3) {
            hpage.wrapText(s);
        } else {
            hpage.loadDefault();
        }
        this.showPage(hpage);
    }

    public DruBrowserPanel(HTMLPage hpage) {
        this.init();
        this.showPage(hpage);
    }

    public void init() {
        this.setBorderLayout(0, 0);
        DruActionRelay relay = new DruActionRelay(this);
        this.dsp = new DScrollPane();
        this.dsp.setVerticalScrollBarAlways();
        this.addDComponent(this.dsp, "Center");
        this.dlfp = new DruFlowPanel();
        this.bprevious = new DruButton("back");
        this.bprevious.setActionRelay(relay);
        this.bnext = new DruButton("next");
        this.bnext.setActionRelay(relay);
        this.dlfp.addPanel(this.bprevious);
        this.dlfp.addPanel(this.bnext);
        this.addPanel(this.dlfp, "North");
        this.htmlPane = new DHTMLPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setDefaultStyleSheet();
        this.dsp.setViewportView(this.htmlPane);
    }

    @Override
    public void setPageSupplier(PageSupplier ps) {
        DruLinkHandler linkHandler = new DruLinkHandler(ps, this);
        this.htmlPane.setHyperlinkHandler(linkHandler);
    }

    public void showBottom() {
        this.dsp.scrollToBottom();
    }

    @Override
    public void showPage(Page page) {
        this.htmlPane.showPage(page);
    }

    public String getHTMLTemplate() {
        if (this.htmlTemplate == null) {
            this.htmlTemplate = JUtil.getRelativeResource(new XdocBase(), "InfoHTMLTemplate.txt");
        }
        return this.htmlTemplate;
    }

    @Override
    public void setBg(Color c) {
        this.dlfp.setBg(c);
        this.htmlPane.setBackground(c);
        super.setBg(c);
    }

    public void labelAction(String s, boolean b) {
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }
}

