/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.swing.DHTMLPane;
import org.catacomb.druid.swing.DScrollPane;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.Page;
import org.catacomb.interlish.structure.PageDisplay;
import org.catacomb.interlish.structure.PageSupplier;
import org.catacomb.interlish.structure.TextSettable;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;

public class DruScrollingHTMLPanel
extends DruPanel
implements TextSettable,
PageDisplay,
ValueWatcher {
    static final long serialVersionUID = 1001L;
    DHTMLPane dHTMLPane;
    PageSupplier pageSupplier;
    boolean preformat = false;
    StringValue stringValue;

    public DruScrollingHTMLPanel() {
        this.setSingle();
        DScrollPane dsp = new DScrollPane();
        dsp.setVerticalScrollBarAlways();
        this.addDComponent(dsp);
        this.dHTMLPane = new DHTMLPane();
        this.dHTMLPane.setDefaultStyleSheet();
        dsp.setViewportView(this.dHTMLPane);
    }

    public void setPreformat(boolean b) {
        this.preformat = b;
    }

    public void setStylesheetPath(String s) {
        this.dHTMLPane.setStylesheetPath(s);
    }

    @Override
    public void setText(String sin) {
        String s = sin;
        if (this.preformat) {
            s = "<pre>\n" + s + "\n</pre>\n";
        }
        this.setContent(s);
    }

    @Override
    public void setBg(Color c) {
        this.dHTMLPane.setBg(c);
        super.setBg(c);
    }

    public void setContent(String s) {
        this.dHTMLPane.showHTML(s);
    }

    @Override
    public void setPageSupplier(PageSupplier ps) {
        this.pageSupplier = ps;
        this.showPage(ps.getPage("/"));
    }

    @Override
    public void showPage(Page p) {
        this.dHTMLPane.showHTML(p.getHTMLText());
    }

    public void setStringValue(StringValue sv) {
        if (this.stringValue != null) {
            this.stringValue.removeValueWatcher(this);
        }
        this.stringValue = sv;
        if (this.stringValue == null) {
            this.dHTMLPane.showHTML("");
        } else {
            this.exportStringValueContent();
            this.stringValue.addValueWatcher(this);
        }
    }

    @Override
    public void valueChangedBy(Value pv, Object src) {
        this.exportStringValueContent();
    }

    private void exportStringValueContent() {
        String s = "";
        if (this.stringValue != null) {
            s = this.stringValue.getString();
        }
        this.setText(s);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }
}

