/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.gui.edit.Effect;
import org.catacomb.druid.swing.DCheckbox;
import org.catacomb.interlish.content.BooleanValue;
import org.catacomb.interlish.structure.Ablable;
import org.catacomb.interlish.structure.BooleanValueEditor;
import org.catacomb.interlish.structure.Toggle;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;

public class DruCheckbox
extends DruGCPanel
implements LabelActor,
Toggle,
Ablable,
BooleanValueEditor,
ValueWatcher {
    static final long serialVersionUID = 1001L;
    ArrayList<Effect> effects;
    DCheckbox dCheckbox;
    BooleanValue booleanValue;

    public DruCheckbox() {
        this(null, null);
    }

    public DruCheckbox(String lab, String mn) {
        this.dCheckbox = new DCheckbox(lab);
        this.setActionMethod(mn);
        this.addSingleDComponent(this.dCheckbox);
        this.dCheckbox.setLabelActor(this);
        this.setBooleanValue(new BooleanValue());
    }

    @Override
    public void setBooleanValue(BooleanValue bv) {
        if (this.booleanValue != null) {
            this.booleanValue.removeValueWatcher(this);
        }
        this.booleanValue = bv;
        if (this.booleanValue == null) {
            this.dCheckbox.setEnabled(false);
        } else {
            this.dCheckbox.setSelected(this.booleanValue.getBoolean());
            this.booleanValue.addValueWatcher(this);
        }
    }

    @Override
    public void valueChangedBy(Value pv, Object src) {
        if (src == this) {
            this.valueChange(this.booleanValue.getBoolean());
        } else {
            if (this.booleanValue == pv) {
                if (this.booleanValue == null) {
                    this.dCheckbox.setEnabled(false);
                } else {
                    this.dCheckbox.setSelected(this.booleanValue.getBoolean());
                }
            } else {
                E.error("value changed by called with mismatched value");
            }
            this.syncEffects();
        }
    }

    @Override
    public void postApply() {
        this.dCheckbox.setMouseActor(this);
    }

    @Override
    public void setBg(Color c) {
        this.dCheckbox.setBg(c);
        super.setBg(c);
    }

    @Override
    public void able(boolean b) {
        this.dCheckbox.setEnabled(b);
    }

    public void setInitialValue(boolean b) {
        if (this.booleanValue != null) {
            this.booleanValue.reportableSetBoolean(b, null);
        } else {
            E.warning("cant set state - no value holder");
        }
    }

    public void applyState() {
        boolean b = this.dCheckbox.isSelected();
        this.booleanValue.reportableSetBoolean(b, this);
        this.syncEffects();
    }

    private void syncEffects() {
        if (this.effects != null) {
            boolean b = this.booleanValue.getBoolean();
            for (Effect eff : this.effects) {
                eff.apply(b);
            }
        }
    }

    @Override
    public void labelAction(String s, boolean b) {
        this.applyState();
    }

    public void setEffects(ArrayList<Effect> arl) {
        this.effects = arl;
    }

    @Override
    public boolean isSelected() {
        return this.booleanValue.getBoolean();
    }

    @Override
    public void setState(boolean b) {
        this.booleanValue.reportableSetBoolean(b, null);
    }
}

