/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.swing.DTextField;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.Ablable;
import org.catacomb.interlish.structure.TextField;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;

public class DruTextField
extends DruGCPanel
implements TextActor,
Ablable,
TextField,
ValueWatcher {
    static final long serialVersionUID = 1001L;
    DTextField dTextField;
    StringValue stringValue;

    public DruTextField() {
        this(null, 20);
    }

    public DruTextField(String s) {
        this(s, s.length());
    }

    public DruTextField(String mn, int width) {
        this.dTextField = new DTextField("", width);
        this.setActionMethod(mn);
        this.addSingleDComponent(this.dTextField);
        this.dTextField.setTextActor(this);
        this.setLineBorder(0xC0C0C0);
    }

    @Override
    public void valueChangedBy(Value pv, Object src) {
        if (src != this) {
            if (this.stringValue == pv) {
                if (this.stringValue == null) {
                    this.dTextField.setText("");
                    this.able(false);
                } else {
                    this.dTextField.setText(this.stringValue.getString());
                    this.able(this.stringValue.isAble());
                }
            } else {
                E.error("value changed by called with mismatched value");
            }
        }
    }

    @Override
    public void setEditable(boolean b) {
        this.dTextField.setEditable(b);
        this.dTextField.setEnabled(b);
    }

    @Override
    public void able(boolean b) {
        this.dTextField.setEnabled(b);
    }

    @Override
    public void setStringValue(StringValue sv) {
        if (this.stringValue != null) {
            this.stringValue.removeValueWatcher(this);
        }
        this.stringValue = sv;
        if (this.stringValue == null) {
            this.able(false);
        } else {
            this.dTextField.setText(this.stringValue.getString());
            this.stringValue.addValueWatcher(this);
            this.able(this.stringValue.isAble());
        }
    }

    public void setLineBorder(int icol) {
        this.dTextField.setLineBorder(icol);
    }

    @Override
    public void textChanged(String s) {
        this.stringValue.reportableSetString(this.dTextField.getText(), this);
    }

    @Override
    public void textEntered(String s) {
        if (this.hasAction()) {
            this.action();
        }
    }

    @Override
    public void textEdited(String s) {
        this.stringValue.editCompleted();
    }

    public void setReturnAction(String action) {
        this.setAction(action);
        this.dTextField.enableReturnEvents();
    }

    @Override
    public void focusGained() {
    }

    @Override
    public void focusLost() {
    }
}

