/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import org.catacomb.druid.build.ContingencyGroup;
import org.catacomb.druid.build.GroupContingent;
import org.catacomb.druid.gui.edit.DruButton;
import org.catacomb.druid.swing.DBaseButton;
import org.catacomb.druid.swing.DToggleButton;
import org.catacomb.icon.DImageIcon;
import org.catacomb.icon.IconLoader;
import org.catacomb.report.E;

public class DruToggleButton
extends DruButton
implements GroupContingent {
    static final long serialVersionUID = 1001L;
    String value;
    ContingencyGroup contingencyGroup;
    DToggleButton toggleButton;

    public DruToggleButton(String lab, String act) {
        super(lab, act);
    }

    @Override
    public DBaseButton makeButton(String lab) {
        this.toggleButton = new DToggleButton(lab);
        return this.toggleButton;
    }

    public void setToggle(String gr, String va) {
        this.value = va;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void setBg(Color c) {
        this.toggleButton.setBg(c);
        this.toggleButton.applyState();
    }

    public void setInitialValue(boolean b) {
        this.toggleButton.setState(b);
    }

    @Override
    public void labelAction(String s, boolean b) {
        this.exportInfo();
        this.applyEffects(b);
        this.unstoredValueChange(b);
        if (this.contingencyGroup != null && b) {
            this.contingencyGroup.deselectOthers(this);
            if (this.contingencyGroup.hasAction()) {
                this.action(this.contingencyGroup.getAction(), this.getValue());
            }
        }
    }

    public void setContingencyGroup(ContingencyGroup cg) {
        this.contingencyGroup = cg;
        this.contingencyGroup.add(this);
    }

    @Override
    public void select() {
        E.info("dtb select ");
        this.toggleButton.setState(true);
    }

    @Override
    public void deselect() {
        this.toggleButton.setState(false);
    }

    public void setOffImage(String iconName) {
        DImageIcon icon = IconLoader.createImageIcon(iconName);
        this.toggleButton.setOffIcon(icon);
    }

    public void setOnImage(String iconName) {
        DImageIcon icon = IconLoader.createImageIcon(iconName);
        this.toggleButton.setOnIcon(icon);
    }

    public void setGroupAction(String action) {
        if (this.contingencyGroup != null) {
            this.contingencyGroup.setAction(action);
        } else {
            E.warning("no contingency group?");
        }
    }
}

