/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.load;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.catacomb.druid.manifest.DecFile;
import org.catacomb.druid.manifest.DecManifest;
import org.catacomb.report.E;

public class XMLStore {
    private static final String MULTICODE = "___MULTI";
    private HashMap<String, String> shortToFullID = new HashMap();
    private HashMap<String, DecFile> fullIDToSource = new HashMap();
    private HashMap<String, ArrayList<String>> shortToFullMulti = new HashMap();

    public void addClasspathManifest(DecManifest manifest) {
        for (DecFile df : manifest.getFiles()) {
            df.setClasspathAccess();
            this.addSource(df);
        }
    }

    public void addFileSystemManifest(DecManifest manifest, File fdir) {
        String cproot = manifest.getRootPath();
        for (DecFile df : manifest.getFiles()) {
            df.setFileSystemAccess(fdir, cproot);
            this.addSource(df);
        }
    }

    public boolean containsSource(String fnm) {
        boolean ret = false;
        if (this.shortToFullID.containsKey(fnm) || this.fullIDToSource.containsKey(fnm)) {
            ret = true;
        }
        return ret;
    }

    public boolean hasMultipleSources(String locator) {
        String v;
        boolean ret = false;
        if (this.shortToFullID.containsKey(locator) && (v = this.shortToFullID.get(locator)).equals(MULTICODE)) {
            ret = true;
        }
        return ret;
    }

    public ArrayList<DecFile> getSources(String locator) {
        ArrayList<DecFile> ret = new ArrayList<DecFile>();
        for (String path : this.shortToFullMulti.get(locator)) {
            ret.add(this.fullIDToSource.get(path));
        }
        return ret;
    }

    public DecFile getSource(String locator) {
        DecFile ret = null;
        if (this.shortToFullMulti.containsKey(locator)) {
            E.error("multiple possible sources for " + locator + " use getSources");
            return null;
        }
        if (this.shortToFullID.containsKey(locator)) {
            String path = this.shortToFullID.get(locator);
            ret = this.fullIDToSource.get(path);
        } else if (this.fullIDToSource.containsKey(locator)) {
            ret = this.fullIDToSource.get(locator);
        } else {
            E.error("cant find resource at " + locator);
            this.dumpStore();
        }
        return ret;
    }

    private void dumpStore() {
        E.info("Known names:");
        for (String sk : this.shortToFullID.keySet()) {
            E.info("   " + sk);
        }
        E.info("Known names:");
        for (String sk : this.shortToFullID.keySet()) {
            E.info("   " + sk);
        }
    }

    public void addSource(DecFile decFile) {
        String dfnm = decFile.getName();
        String fullid = decFile.getFullID();
        if (this.shortToFullID.containsKey(dfnm)) {
            if (this.shortToFullMulti.containsKey(dfnm)) {
                this.shortToFullMulti.get(dfnm).add(fullid);
            } else {
                ArrayList<String> al = new ArrayList<String>();
                al.add(this.shortToFullID.get(dfnm));
                al.add(fullid);
                this.shortToFullMulti.put(dfnm, al);
                this.shortToFullID.put(dfnm, MULTICODE);
            }
        } else {
            this.shortToFullID.put(dfnm, fullid);
        }
        this.fullIDToSource.put(fullid, decFile);
    }

    public void newSourceFile(File f, File rootFolder) {
        DecFile df = new DecFile(f, rootFolder);
        this.addSource(df);
    }
}

