/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.manifest;

import java.io.File;
import java.util.ArrayList;
import org.catacomb.druid.manifest.ClassRole;
import org.catacomb.druid.manifest.DecFile;
import org.catacomb.interlish.resource.ResourceRole;
import org.catacomb.interlish.resource.Role;
import org.catacomb.interlish.structure.Element;
import org.catacomb.report.E;
import org.catacomb.serial.ElementXMLReader;
import org.catacomb.serial.Serializer;
import org.catacomb.util.FileUtil;

public class DecManifest {
    public String rootPath;
    public ArrayList<DecFile> files;
    public ArrayList<Role> roles;

    public DecManifest() {
    }

    public DecManifest(File basedir, String path) {
        this.rootPath = path;
        this.init();
        this.addFilesFrom(basedir, this.rootPath);
    }

    public ArrayList<DecFile> getFiles() {
        return this.files;
    }

    public ArrayList<Role> getRoles() {
        return this.roles;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void init() {
        this.files = new ArrayList();
        this.roles = new ArrayList();
    }

    void addFilesFrom(File fdir, String psf) {
        File[] af = fdir.listFiles();
        int i = 0;
        while (i < af.length) {
            File f = af[i];
            if (f.getName().endsWith(".xml")) {
                this.addFile(psf, f);
            } else if (f.isDirectory()) {
                String psc = psf;
                if (psc.length() > 0) {
                    psc = String.valueOf(psc) + "/";
                }
                psc = String.valueOf(psc) + f.getName();
                this.addFilesFrom(f, psc);
            }
            ++i;
        }
    }

    private void addFile(String psf, File f) {
        String fnm = f.getName();
        DecFile xmf = new DecFile(psf, fnm);
        String jpath = psf.replaceAll("/", ".");
        String stxt = FileUtil.readStringFromFile(f);
        if (stxt.trim().length() > 10) {
            Element elt = (Element)ElementXMLReader.deserialize(stxt);
            if (elt.getName().equals("DeclarationReading")) {
                this.addInfoFrom(elt, jpath);
            } else {
                this.addResource(elt, xmf);
            }
        }
    }

    private void addInfoFrom(Element parent, String jpath) {
        for (Element elt : parent.getElements()) {
            String cls;
            if (elt.getName().equals("Instantiable")) {
                cls = elt.getAttribute("class");
                String prv = elt.getAttribute("provides");
                if (cls != null) {
                    if (prv == null) {
                        prv = cls.substring(cls.lastIndexOf(".") + 1, cls.length());
                    }
                    if (cls.indexOf(".") < 0) {
                        cls = String.valueOf(jpath) + "." + cls;
                    }
                    this.roles.add(new ClassRole(cls, "provides", prv));
                    continue;
                }
                E.error("cant extract info from " + elt);
                continue;
            }
            if (elt.getName().equals("Factory")) {
                cls = elt.getAttribute("class");
                String val = elt.getAttribute("makes");
                if (cls != null && val != null) {
                    this.roles.add(new ClassRole(cls, "makes", val));
                    continue;
                }
                E.error("cant extract info from " + elt);
                continue;
            }
            E.error("unhandled info element " + elt);
        }
    }

    private void addResource(Element elt, DecFile xmf) {
        this.files.add(xmf);
        ArrayList<Element> subelements = new ArrayList<Element>();
        if (elt.hasElements()) {
            subelements.addAll(elt.getElements());
        }
        for (Element sub : subelements) {
            if (!sub.getName().equals("Role")) continue;
            ResourceRole role = new ResourceRole();
            role.populateFrom(sub);
            role.setResource(xmf.getName());
            this.roles.add(role);
        }
    }

    public static DecManifest rebuildManifest(File ftop) {
        File fdest = new File(ftop, "DecManifest.xml");
        FileUtil.writeStringToFile("", fdest);
        DecManifest xm = new DecManifest(ftop, "");
        String ser = Serializer.serialize(xm);
        FileUtil.writeStringToFile(ser, fdest);
        return xm;
    }
}

