/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.RolloverEffect;
import org.catacomb.icon.DImageIcon;
import org.catacomb.icon.IconLoader;

public class DImageButton
extends JButton
implements ActionListener {
    static final long serialVersionUID = 1001L;
    String actionCommand;
    RolloverEffect rollover;
    LabelActor lact;

    public DImageButton(String image, String tooltip) {
        this.setToolTipText(tooltip);
        DImageIcon icon = IconLoader.createImageIcon(image);
        if (icon == null) {
            this.setText("err");
        } else {
            this.setIcon(icon);
        }
        this.setFont(new Font("sansserif", 0, 12));
        this.rollover = new RolloverEffect(this, 0, 2);
        this.addMouseListener(this.rollover);
        this.addActionListener(this);
        this.setFocusPainted(false);
    }

    public void setBg(Color c) {
        this.setBackground(c);
    }

    @Override
    public void setActionCommand(String s) {
        this.actionCommand = s;
    }

    public void setLabelActor(LabelActor la) {
        this.lact = la;
    }

    @Override
    public void actionPerformed(ActionEvent aev) {
        if (this.lact == null) {
            this.lact.labelAction(this.actionCommand, true);
        }
    }

    @Override
    public String toString() {
        return "DImageButton ";
    }
}

