/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.catacomb.druid.swing.DListCellRenderer;
import org.catacomb.interlish.structure.ColorMapped;
import org.catacomb.interlish.structure.Colored;
import org.catacomb.interlish.structure.Labelled;
import org.catacomb.report.E;

public class DListColorRenderer
extends JPanel
implements DListCellRenderer {
    static final long serialVersionUID = 1001L;
    JLabel nameLabel;
    JPanel colorPanel;
    Color csel = new Color(230, 230, 220);
    JPanel jpl;

    public DListColorRenderer() {
        this.setLayout(new BorderLayout(2, 2));
        Font plainfont = new Font("sansserif", 0, 12);
        this.colorPanel = new JPanel();
        this.colorPanel.setPreferredSize(new Dimension(18, 12));
        this.colorPanel.setMinimumSize(new Dimension(18, 12));
        this.colorPanel.setMaximumSize(new Dimension(18, 12));
        this.nameLabel = new JLabel();
        this.nameLabel.setFont(plainfont);
        this.jpl = new JPanel();
        this.jpl.setLayout(new FlowLayout(0, 4, 2));
        this.jpl.add(this.colorPanel);
        this.jpl.add(this.nameLabel);
        this.add("Center", this.jpl);
        Color borderC = new Color(0xA0A0A0);
        this.colorPanel.setBorder(BorderFactory.createLineBorder(borderC));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = "";
        s = value instanceof Labelled ? ((Labelled)value).getLabel() : value.toString();
        this.nameLabel.setText(s);
        Color cbg = isSelected ? this.csel : list.getBackground();
        this.setBackground(cbg);
        this.jpl.setBackground(cbg);
        if (value instanceof Colored) {
            Color c = ((Colored)value).getColor();
            this.colorPanel.setBackground(c);
        } else {
            E.warning("not a colored list item " + value + " " + value.getClass());
        }
        if (value instanceof ColorMapped) {
            E.missing("should make specific renderer for color mapped items");
        }
        return this;
    }
}

