/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.catacomb.druid.swing.DListCellRenderer;
import org.catacomb.icon.IconLoader;
import org.catacomb.interlish.structure.Labelled;
import org.catacomb.interlish.structure.Progressed;
import org.catacomb.interlish.structure.StateProcess;

public class DListProgressRenderer
extends JPanel
implements DListCellRenderer {
    static final long serialVersionUID = 1001L;
    JLabel nameLabel;
    JLabel statusLabel;
    JLabel progressLabel;
    JProgressBar progressBar;
    JPanel rtPanel;
    Icon newIcon;
    Icon readyIcon;
    Icon runningIcon;
    Icon doneIcon;
    Icon stoppedIcon;
    Icon errorIcon;
    Color csel = new Color(230, 230, 220);

    public DListProgressRenderer() {
        this.setLayout(new GridLayout(3, 1, 6, 2));
        Font plainfont = new Font("sansserif", 0, 12);
        this.nameLabel = new JLabel();
        this.nameLabel.setFont(plainfont);
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(plainfont);
        this.progressLabel = new JLabel("             ", null, 11);
        this.progressLabel.setFont(plainfont);
        this.newIcon = IconLoader.createImageIcon("statusNew.gif");
        this.doneIcon = IconLoader.createImageIcon("statusDone.gif");
        this.readyIcon = IconLoader.createImageIcon("statusReady.gif");
        this.runningIcon = IconLoader.createImageIcon("statusRunning.gif");
        this.stoppedIcon = IconLoader.createImageIcon("statusStopped.gif");
        this.errorIcon = IconLoader.createImageIcon("statusErr.gif");
        this.statusLabel.setIcon(this.doneIcon);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setOpaque(false);
        this.progressBar.setPreferredSize(new Dimension(140, 8));
        this.progressBar.setBorderPainted(true);
        Color borderC = new Color(0xA0A0A0);
        this.progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(borderC)));
        this.rtPanel = new JPanel();
        this.rtPanel.setBackground(Color.white);
        this.rtPanel.setLayout(new BorderLayout(4, 4));
        this.rtPanel.add("East", this.statusLabel);
        this.rtPanel.add("Center", this.progressBar);
        this.add(this.nameLabel);
        this.add(this.rtPanel);
        this.add(this.progressLabel);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = "";
        s = value instanceof Labelled ? ((Labelled)value).getLabel() : value.toString();
        int istat = 0;
        if (value instanceof StateProcess) {
            istat = ((StateProcess)value).getProcessState();
        }
        double fprog = 0.0;
        String tprog = "";
        if (value instanceof Progressed) {
            fprog = ((Progressed)value).getProgress();
            tprog = ((Progressed)value).getProgressDescription();
        }
        this.nameLabel.setText(s);
        Color cbg = isSelected ? this.csel : list.getBackground();
        Color cfg = isSelected ? list.getSelectionForeground() : list.getForeground();
        this.setBackground(cbg);
        this.rtPanel.setBackground(cbg);
        this.nameLabel.setForeground(cfg);
        this.progressBar.setBackground(cbg);
        switch (istat) {
            case 0: {
                this.statusLabel.setIcon(this.newIcon);
                break;
            }
            case 1: {
                this.statusLabel.setIcon(this.readyIcon);
                break;
            }
            case 2: {
                this.statusLabel.setIcon(this.runningIcon);
                break;
            }
            case 5: {
                this.statusLabel.setIcon(this.errorIcon);
                break;
            }
            case 4: {
                this.statusLabel.setIcon(this.doneIcon);
                break;
            }
            case 3: {
                this.statusLabel.setIcon(this.stoppedIcon);
            }
        }
        this.progressBar.setValue((int)(100.0 * fprog));
        this.progressLabel.setText(tprog);
        return this;
    }
}

