/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.DMouseRelay;
import org.catacomb.druid.swing.RolloverEffect;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.structure.MouseActor;
import org.catacomb.interlish.structure.MouseSource;

public class DSlider
extends JPanel
implements DComponent,
MouseSource,
MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 1001L;
    LabelActor labelActor;
    int nmax;
    int islider;
    String descriptionText;
    String[] values;
    int xdown;
    int ydown;
    long downtime;
    Color bgColor;
    RolloverEffect rollover;
    int state;
    static final int NONE = 0;
    static final int DRAG = 1;

    public DSlider() {
        this(1);
    }

    public DSlider(int n) {
        this.nmax = n;
        this.values = new String[n];
        int i = 0;
        while (i < n) {
            this.values[i] = "" + i;
            ++i;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.attachRollover();
    }

    @Override
    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setNPoint(int npt) {
        this.nmax = npt;
        this.values = new String[this.nmax];
        int i = 0;
        while (i < this.nmax) {
            this.values[i] = "" + i;
            ++i;
        }
        this.repaint();
    }

    @Override
    public void setMouseActor(MouseActor ma) {
        this.addMouseListener(new DMouseRelay(ma));
    }

    public void setBg(Color col) {
        this.setBackground(col);
        this.bgColor = col;
        this.rollover.setBg(col);
    }

    public void attachRollover() {
        this.rollover = new RolloverEffect(this);
        this.addMouseListener(this.rollover);
    }

    public void setLabelActor(LabelActor lact) {
        this.labelActor = lact;
    }

    private void notifyChange() {
        if (this.labelActor != null) {
            this.labelActor.labelAction("change", true);
        }
    }

    public void export() {
        this.notifyChange();
    }

    public void setValues(String[] sa) {
        this.values = sa;
        this.nmax = sa.length;
        this.showValue(0);
    }

    public int getValue() {
        return this.islider;
    }

    public void showValue(int iv) {
        if (iv != this.islider) {
            this.islider = iv;
            this.repaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(80, 20);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(140, 22);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.realPaint(g);
    }

    public void realPaint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.bgColor == null) {
            this.bgColor = this.getBackground();
        }
        g.setColor(this.bgColor);
        g.fillRect(0, 0, w, h);
        this.paintArrows(g);
        this.paintKnob(g);
        if (this.descriptionText != null) {
            g.setColor(Color.black);
            g.drawString(this.descriptionText, 40, h - 5);
        }
    }

    private void paintArrows(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Color cbg = this.bgColor;
        Color cbr = cbg.brighter();
        Color cdk = cbg.darker();
        int hh = h / 2;
        g.setColor(cbr);
        g.drawLine(4, hh, 15, 4);
        g.drawLine(w - 15, h - 4, w - 15, 4);
        g.setColor(cdk);
        g.drawLine(15, 4, 15, h - 4);
        g.drawLine(4, hh, 15, h - 4);
        g.drawLine(w - 15, h - 4, w - 4, hh);
        g.drawLine(w - 15, 4, w - 4, hh);
    }

    private void paintKnob(Graphics g) {
        double f;
        int icen;
        int width = this.getWidth();
        int height = this.getHeight();
        int hh = height / 2;
        if (this.nmax < 1) {
            this.nmax = 1;
        }
        if (this.islider >= this.nmax) {
            this.islider = this.nmax - 1;
        }
        if ((icen = (int)(25.0 + (f = ((double)this.islider + 0.5) / (double)this.nmax) * (double)(width - 50))) < 25) {
            icen = 25;
        }
        if (icen > width - 25) {
            icen = width - 25;
        }
        this.drawUpButton(g, icen, hh, 5, 5);
        if (this.islider >= 0 && this.values != null && this.islider < this.values.length && this.values[this.islider] != null) {
            g.setColor(Color.black);
            if (icen < 80) {
                g.drawString(this.values[this.islider], 100, 18);
            } else {
                g.drawString(this.values[this.islider], 30, 18);
            }
        }
    }

    private void drawUpButton(Graphics g, int icx, int icy, int hw, int hh) {
        Color c = this.getBackground();
        g.setColor(c.darker());
        g.drawLine(icx - hw - 1, icy + hh + 1, icx + hw + 1, icy + hh + 1);
        g.drawLine(icx - hw, icy + hh, icx + hw, icy + hh);
        g.drawLine(icx + hw + 1, icy - hh - 1, icx + hw + 1, icy + hh + 1);
        g.drawLine(icx + hw, icy - hh, icx + hw, icy + hh);
        g.setColor(c.brighter());
        g.drawLine(icx - hw - 1, icy - hh - 1, icx + hw + 1, icy - hh - 1);
        g.drawLine(icx - hw, icy - hh, icx + hw, icy - hh);
        g.drawLine(icx - hw - 1, icy - hh - 1, icx - hw - 1, icy + hh + 1);
        g.drawLine(icx - hw, icy - hh, icx - hw, icy + hh);
    }

    public void nudgeLeft() {
        if (this.islider > 0) {
            --this.islider;
            this.repaint();
            this.export();
        }
    }

    public void nudgeRight() {
        if (this.islider < this.nmax - 1) {
            ++this.islider;
            this.repaint();
            this.export();
        }
    }

    public void rsfMouseDown(int x, int y, long when, int button) {
        this.state = 0;
        if (x > 15 && x < this.getWidth() - 15) {
            this.state = 1;
            this.moveTo(x);
        } else if (x < 15) {
            this.nudgeLeft();
        } else if (x > this.getWidth() - 15) {
            this.nudgeRight();
        }
    }

    public void rsfMouseUp(int x, int y) {
    }

    public void rsfMouseDrag(int x, int y) {
        if (this.state == 1) {
            this.moveTo(x);
        }
    }

    private void moveTo(int x) {
        int width = this.getWidth();
        double frel = ((double)x - 15.0) / ((double)width - 30.0);
        int oslider = this.islider;
        this.islider = (int)(frel * (double)this.nmax + 0.0);
        if (this.islider < 0) {
            this.islider = 0;
        }
        if (this.islider > this.nmax - 1) {
            this.islider = this.nmax - 1;
        }
        if (this.islider != oslider) {
            this.export();
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.rsfMouseDrag(x, y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        long when = e.getWhen();
        int modif = e.getModifiers();
        int button = 0;
        if (modif == 16) {
            button = 1;
        } else if (modif == 8) {
            button = 2;
        } else if (modif == 4) {
            button = 3;
        }
        this.rsfMouseDown(x, y, when, button);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.rsfMouseUp(x, y);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
    }

    public void pointShown(int ifr, String desc) {
        this.descriptionText = desc;
        this.showValue(ifr);
    }
}

