/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.interlish.content.IntPosition;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.structure.TextPainter;

public class DTextCanvas
extends JPanel
implements DComponent,
Scrollable {
    private static final long serialVersionUID = 1L;
    BasicStroke bs1 = new BasicStroke(1.0f);
    Color bgColor = new Color(32, 232, 238);
    boolean antialias;
    TextPainter textPainter;
    int txtHeight;
    DPanel parentPanel;

    public DTextCanvas() {
        this.setFont(new Font("sansserif", 0, 12));
        this.txtHeight = 400;
    }

    @Override
    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setTextPainter(TextPainter tp) {
        this.textPainter = tp;
    }

    @Override
    public void paintComponent(Graphics g0) {
        g0.setColor(this.bgColor);
        g0.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g = (Graphics2D)g0;
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.simpleStroke(g);
        this.paint2D(g);
    }

    final void simpleStroke(Graphics2D g) {
        g.setStroke(this.bs1);
    }

    public void paint2D(Graphics2D g) {
        if (this.textPainter != null) {
            this.textPainter.paintText(g);
            this.txtHeight = this.textPainter.getFullTextHeight();
        }
    }

    public void requestRepaint() {
        this.repaint();
    }

    public IntPosition getScreenPosition() {
        Point p = this.getLocationOnScreen();
        return new IntPosition((int)p.getX(), (int)p.getY());
    }

    public void setAntialias(boolean b) {
        this.antialias = b;
        this.repaint();
    }

    public boolean containsPoint(IntPosition pos) {
        int x = pos.getX();
        int y = pos.getY();
        boolean ret = x > 5 && y > 10 && x < this.getWidth() - 10 && y < this.getHeight() - 10;
        return ret;
    }

    public void contentSizeChanged() {
        this.invalidate();
        if (this.parentPanel != null) {
            this.parentPanel.validate();
        }
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.txtHeight);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension d;
        Dimension ret = d = this.getPreferredSize();
        return ret;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 25;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 25;
    }

    public void setParentContainer(DPanel dp) {
        this.parentPanel = dp;
    }
}

