/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.base;

import java.util.ArrayList;
import org.catacomb.druid.xtext.base.Block;
import org.catacomb.druid.xtext.base.DownBlock;
import org.catacomb.druid.xtext.base.TextBlock;
import org.catacomb.druid.xtext.base.UpBlock;
import org.catacomb.druid.xtext.base.WordBlock;
import org.catacomb.report.E;

public class ContainerBlock
extends Block {
    public ArrayList<Block> items = new ArrayList();
    DownBlock downBlock;
    UpBlock upBlock;

    public void addBlock(Block bw) {
        this.items.add(bw);
        bw.setParent(this);
    }

    public ArrayList<Block> getBlocks() {
        return this.items;
    }

    public void link() {
        DownBlock db = new DownBlock(this);
        this.setDownBlock(db);
        this.setNext(db);
        Block bcur = db;
        for (Block b : this.getBlocks()) {
            bcur.setNext(b);
            if (b instanceof TextBlock) {
                bcur = b;
                continue;
            }
            if (b instanceof ContainerBlock) {
                ContainerBlock cb = (ContainerBlock)b;
                cb.link();
                bcur = cb.getUpBlock();
                continue;
            }
            E.error("wrong block type " + b);
        }
        UpBlock bup = new UpBlock(this);
        this.setUpBlock(bup);
        bcur.setNext(bup);
    }

    public DownBlock getDownBlock() {
        return this.downBlock;
    }

    public void setDownBlock(DownBlock downBlock) {
        this.downBlock = downBlock;
    }

    public UpBlock getUpBlock() {
        return this.upBlock;
    }

    public void setUpBlock(UpBlock upBlock) {
        this.upBlock = upBlock;
    }

    public static ContainerBlock newEmptyText() {
        ContainerBlock cb = new ContainerBlock();
        cb.addBlock(new WordBlock("hello"));
        cb.link();
        return cb;
    }
}

