/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.canvas;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.catacomb.druid.swing.DTextCanvas;
import org.catacomb.druid.swing.dnd.Region;
import org.catacomb.druid.swing.dnd.RegionBoard;
import org.catacomb.druid.xtext.base.WordBlock;
import org.catacomb.druid.xtext.canvas.FontStore;
import org.catacomb.druid.xtext.data.PageDataStore;
import org.catacomb.druid.xtext.data.XItem;
import org.catacomb.druid.xtext.data.XRelation;
import org.catacomb.druid.xtext.data.XRelationType;
import org.catacomb.druid.xtext.data.XType;
import org.catacomb.druid.xtext.data.XTypeStore;
import org.catacomb.interlish.structure.TextDisplayed;
import org.catacomb.interlish.structure.TextPainter;

public class DataBoard
extends RegionBoard
implements TextPainter {
    FontStore fontStore;
    PageDataStore pageDataStore;
    int width;
    int height;
    int itxt;
    int jtxt;

    public DataBoard(DTextCanvas dtc) {
        super(dtc);
        dtc.setTextPainter(this);
        this.fontStore = FontStore.instance();
    }

    @Override
    public void paintText(Graphics2D g) {
        if (this.pageDataStore == null) {
            return;
        }
        this.width = this.canvas.getWidth();
        this.height = this.canvas.getHeight();
        g.setFont(this.fontStore.getActiveFont());
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        this.itxt = 10;
        this.jtxt = 30;
        for (ArrayList<XItem> alxi : this.pageDataStore.getLists()) {
            XItem xi0 = alxi.get(0);
            XType xt = xi0.getType();
            g.setFont(this.fontStore.getH2Font());
            g.drawString(xt.getID(), this.itxt, this.jtxt);
            this.itxt += g.getFontMetrics().stringWidth(xt.getID()) + 6;
            this.itxt += 8;
            g.setFont(this.fontStore.getActiveFont());
            if (xt.hasFields()) {
                this.drawBracketedList(g, fm, xt.getFieldNames());
            }
            for (XItem xit : alxi) {
                this.jtxt += 18;
                this.itxt = 32;
                g.fillOval(20, this.jtxt - 8, 6, 6);
                g.setFont(this.fontStore.getBoldFont());
                String stxt = xit.getText();
                if (stxt == null || stxt.length() == 0) {
                    g.setColor(Color.red);
                    stxt = "- name -";
                    g.drawString(stxt, this.itxt, this.jtxt);
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color.black);
                    g.drawString(xit.getText(), this.itxt, this.jtxt);
                }
                this.itxt += g.getFontMetrics().stringWidth(stxt) + 8;
                g.setFont(this.fontStore.getActiveFont());
                if (!xt.hasFields()) continue;
                for (XType ft : xt.getFields()) {
                    int w;
                    String sid = ft.getID();
                    String val = xit.getFieldValue(sid);
                    if (val == null) {
                        g.setColor(Color.red);
                        w = fm.stringWidth(sid);
                        if (this.itxt + w > this.width) {
                            this.itxt = 48;
                            this.jtxt += 18;
                        }
                        g.drawLine(this.itxt, this.jtxt + 2, this.itxt + w, this.jtxt + 2);
                        this.addRegion(this.itxt, this.jtxt + 4, w, 16, xit, sid, 2);
                        g.drawString(sid, this.itxt, this.jtxt);
                        this.itxt += w;
                        this.itxt += 12;
                        g.setColor(Color.black);
                        continue;
                    }
                    w = fm.stringWidth(val = String.valueOf(val) + ", ");
                    if (this.itxt + w > this.width) {
                        this.itxt = 48;
                        this.jtxt += 18;
                    }
                    g.drawString(val, this.itxt, this.jtxt);
                    this.itxt += w;
                }
            }
            this.itxt = 10;
            this.jtxt += 25;
        }
        this.jtxt += 20;
        if (this.pageDataStore.hasRelations()) {
            g.setFont(this.fontStore.getH2Font());
            g.drawString("Relations", this.itxt, this.jtxt);
            this.jtxt += 20;
            for (XRelation xr : this.pageDataStore.getRelations()) {
                this.itxt = 10;
                String atxt = xr.getAText();
                if (atxt == null || atxt.length() == 0) {
                    g.setColor(Color.red);
                    g.drawRect(this.itxt, this.jtxt - 12, 50, 16);
                    this.addRegion(this.itxt, this.jtxt + 4, 50, 16, xr, "left", 2);
                    this.itxt += 60;
                } else {
                    g.setFont(this.fontStore.getActiveFont());
                    g.setColor(Color.black);
                    g.drawString(atxt, this.itxt, this.jtxt);
                    this.itxt += g.getFontMetrics().stringWidth(atxt) + 10;
                }
                g.setFont(this.fontStore.getDefaultItalicFont());
                g.setColor(Color.black);
                String tid = xr.getTypeID();
                g.drawString(tid, this.itxt, this.jtxt);
                this.itxt += g.getFontMetrics().stringWidth(tid) + 10;
                String btxt = xr.getBText();
                if (btxt == null || btxt.length() == 0) {
                    g.setColor(Color.red);
                    g.drawRect(this.itxt, this.jtxt - 12, 50, 16);
                    this.addRegion(this.itxt, this.jtxt + 4, 50, 16, xr, "right", 2);
                    this.itxt += 60;
                } else {
                    g.setFont(this.fontStore.getActiveFont());
                    g.setColor(Color.black);
                    g.drawString(btxt, this.itxt, this.jtxt);
                    this.itxt += g.getFontMetrics().stringWidth(btxt) + 10;
                }
                this.jtxt += 18;
            }
        }
        int ofth = this.fullTextHeight;
        this.fullTextHeight = this.jtxt + 10;
        if (Math.abs(this.fullTextHeight - ofth) > 10) {
            this.canvas.contentSizeChanged();
        }
    }

    private void drawBracketedList(Graphics2D g, FontMetrics fm, String[] sa) {
        int n = sa.length;
        int i = 0;
        while (i < n) {
            int w;
            String s = sa[i];
            if (i == 0) {
                s = "(" + s;
            }
            if (i < n - 1) {
                s = String.valueOf(s) + ", ";
            }
            if (i == n - 1) {
                s = String.valueOf(s) + ")";
            }
            if (this.itxt + (w = fm.stringWidth(s)) > this.width) {
                this.itxt = 20;
                this.jtxt += 18;
            }
            g.drawString(s, this.itxt, this.jtxt);
            this.itxt += w;
            ++i;
        }
    }

    @Override
    public void dropOn(Object src, Region reg) {
        Object tgt = reg.getRef();
        String tag = reg.getTag();
        String txt = "err";
        if (src instanceof TextDisplayed) {
            txt = ((TextDisplayed)src).getDisplayText();
        }
        if (tgt instanceof XItem) {
            ((XItem)tgt).setField(tag, txt);
            if (src instanceof WordBlock) {
                this.applyType((WordBlock)src, XTypeStore.instance().getPropertyType());
            }
        } else if (tgt instanceof XRelation) {
            if (tag.equals("left")) {
                ((XRelation)tgt).setA(txt, src);
            } else {
                ((XRelation)tgt).setB(txt, src);
            }
            if (src instanceof WordBlock) {
                this.applyType((WordBlock)src, XTypeStore.instance().getThingType());
            }
        }
        this.repaint();
    }

    @Override
    public void dropGeneral(Object src) {
        if (src instanceof XType) {
            XItem xit = new XItem((XType)src, "");
            this.pageDataStore.addItem(xit);
        } else if (src instanceof XRelationType) {
            XRelation xr = new XRelation((XRelationType)src);
            this.pageDataStore.addRelation(xr);
        }
        this.repaint();
    }

    private void applyType(WordBlock wbin, XType xt) {
        WordBlock wb = wbin;
        while (wb != null) {
            wb.setType(xt);
            wb = wb.getLinkee();
        }
    }

    public void emptyClick() {
    }

    public void setPageDataStore(PageDataStore pdStore) {
        this.pageDataStore = pdStore;
    }
}

