/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.geom;

import java.util.ArrayList;
import org.catacomb.be.Position;
import org.catacomb.interlish.content.Heading;
import org.catacomb.report.E;

public class Geom {
    public static double allowedFraction(double x, double y, double vx, double vy, double[] xyxy) {
        double fc = Geom.fCross(x, y, x + vx, y + vy, xyxy[0], xyxy[1], xyxy[2], xyxy[3]);
        return fc;
    }

    private static final double fCross(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd) {
        double va = xb - xa;
        double vb = xd - xc;
        double vc = yb - ya;
        double vd = yd - yc;
        double det = vd * va - vb * vc;
        double fcr = -1.0;
        double gcr = -1.0;
        if (det != 0.0) {
            double rx = xc - xa;
            double ry = yc - ya;
            fcr = (vd * rx - vb * ry) / det;
            gcr = (vc * rx - va * ry) / det;
        }
        if (gcr < 0.0 || gcr > 1.0) {
            fcr = -1.0;
        }
        return fcr;
    }

    public static double perimeterDistance(Position pos, Heading h, double radius) {
        double vx = h.getX();
        double vy = h.getY();
        double px = pos.getX();
        double py = pos.getY();
        double a = 1.0;
        double b = 2.0 * vx * px + 2.0 * vy * py;
        double c = px * px + py * py - radius * radius;
        double det = Math.sqrt(b * b - 4.0 * a * c);
        double da = (-1.0 * b + det) / 2.0;
        double db = (-1.0 * b - det) / 2.0;
        return Math.max(da, db);
    }

    public static double distanceTo(Position pos, double[] xyxy) {
        double x = pos.getX();
        double y = pos.getY();
        double d1q = Geom.distance2(x, y, xyxy[0], xyxy[1]);
        double d2q = Geom.distance2(x, y, xyxy[2], xyxy[3]);
        double dsq = Geom.distance2(xyxy[0], xyxy[1], xyxy[2], xyxy[3]);
        double ret = 0.0;
        if (Math.abs(d1q - d2q) < dsq) {
            double ddq = d1q - d2q;
            double w = 2.0 * d1q + 2.0 * d2q - dsq - ddq * ddq / dsq;
            ret = 0.5 * Math.sqrt(w);
        } else {
            ret = Math.sqrt(Math.min(d1q, d2q));
        }
        return ret;
    }

    public static double altDistanceTo(Position pos, double[] xyxy) {
        double x = pos.getX();
        double y = pos.getY();
        double d1 = Geom.distance(x, y, xyxy[0], xyxy[1]);
        double d2 = Geom.distance(x, y, xyxy[2], xyxy[3]);
        double ds = Geom.distance(xyxy[0], xyxy[1], xyxy[2], xyxy[3]);
        double cos1 = (ds * ds + d1 * d1 - d2 * d2) / (2.0 * ds * d1);
        double cos2 = (ds * ds + d2 * d2 - d1 * d1) / (2.0 * ds * d2);
        double sin1 = Math.sqrt(1.0 - cos1 * cos1);
        double dperp = d1 * sin1;
        double ret = Math.min(d1, d2);
        if (cos1 > 0.0 && cos2 > 0.0) {
            ret = dperp;
        }
        return ret;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double distance2(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static void main(String[] argv) {
        double[] xyxy = new double[4];
        int i = 0;
        while (i < 4) {
            xyxy[i] = 5.0 * Math.random();
            ++i;
        }
        int ip = 0;
        while (ip < 10) {
            Position p = new Position(5.0 * Math.random(), 5.0 * Math.random());
            E.info("seg distances " + Geom.distanceTo(p, xyxy) + " " + Geom.altDistanceTo(p, xyxy));
            ++ip;
        }
    }

    public static double distanceBetween(Position pos, Position pse) {
        double dx = pse.getX() - pos.getX();
        double dy = pse.getY() - pos.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static Position[] getBoundary(ArrayList<Position> apts) {
        Position[] pa = apts.toArray(new Position[apts.size()]);
        return pa;
    }

    public static Position translatedRotatedPoint(Position b, Position pc, Heading h) {
        double vc = h.getX();
        double vs = h.getY();
        double xc = pc.getX();
        double yc = pc.getY();
        Position ret = new Position(xc + vc * b.getX() - vs * b.getY(), yc + vs * b.getX() + vc * b.getY());
        return ret;
    }

    public static Position[] translatedRotatedPoints(Position[] bdry, Position pc, Heading h) {
        int nb = bdry.length;
        Position[] rp = new Position[nb];
        double vc = h.getX();
        double vs = h.getY();
        double xc = pc.getX();
        double yc = pc.getY();
        int i = 0;
        while (i < nb) {
            Position b = bdry[i];
            rp[i] = new Position(xc + vc * b.getX() - vs * b.getY(), yc + vs * b.getX() + vc * b.getY());
            ++i;
        }
        return rp;
    }

    public static Position[] copyPositionArray(Position[] pa) {
        int np = pa.length;
        Position[] ret = new Position[np];
        int i = 0;
        while (i < np) {
            ret[i] = pa[i].copy();
            ++i;
        }
        return ret;
    }

    public static Position[] translatedRotatedPoints(Position[] bdry, Position pt, Heading h, Position pcen) {
        int nb = bdry.length;
        Position[] rp = new Position[nb];
        double vc = h.getX();
        double vs = h.getY();
        double xt = pt.getX();
        double yt = pt.getY();
        double xcr = pcen.getX();
        double ycr = pcen.getY();
        int i = 0;
        while (i < nb) {
            Position b = bdry[i];
            double dx = b.getX() - xcr;
            double dy = b.getY() - ycr;
            double xnew = xt + vc * dx - vs * dy + xcr;
            double ynew = yt + vs * dx + vc * dy + ycr;
            rp[i] = new Position(xnew, ynew);
            ++i;
        }
        return rp;
    }

    public static double intersectFraction(Position pa, Position pb, double[] xyxy) {
        return Geom.fCross(pa.getX(), pa.getY(), pb.getX(), pb.getY(), xyxy[0], xyxy[1], xyxy[2], xyxy[3]);
    }

    public static double angleTo(Position position) {
        return Math.atan2(position.getY(), position.getX());
    }

    public static void rotateAbout(Position[] rp, Position rpc, double rad) {
        int nb = rp.length;
        int i = 0;
        while (i < nb) {
            rp[i].rotateAbout(rpc, rad);
            ++i;
        }
    }
}

