/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import java.awt.Color;
import org.catacomb.graph.drawing.FixedDrawingComponent;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.gui.Painter;

public class Rectangle
extends FixedDrawingComponent {
    public double x;
    public double y;
    public double rx;
    public double ry;

    public Rectangle() {
    }

    public Rectangle(double x1, double y1, double rx1, double ry1) {
        this.x = x1;
        this.y = y1;
        this.rx = rx1;
        this.ry = ry1;
        this.setColor(Color.black);
        this.setClosed();
        this.setFillColor(Color.orange);
    }

    public void setSize(double sx, double sy) {
        this.rx = sx;
        this.ry = sy;
    }

    @Override
    public void instruct(Painter p, double offx, double offy, double scale) {
        if (this.isFilled()) {
            p.drawFilledRectangle(offx + scale * this.x, offy + scale * this.y, scale * this.rx, scale * this.ry, this.getFillColor(), this.getColor(), this.getWidth(), this.widthIsPixels());
        } else {
            p.drawRectangle(offx + scale * this.x, offy + scale * this.y, scale * this.rx, scale * this.ry, this.getColor(), this.getWidth(), this.widthIsPixels());
        }
    }

    @Override
    public void applyToShape(Shape shp) {
        shp.setCurviness(0.0);
        this.applySymmetryToShape(shp);
        double[] xpts = new double[]{this.x - this.rx, this.x - this.rx, this.x + this.rx, this.x + this.rx};
        double[] ypts = new double[]{this.y - this.ry, this.y + this.ry, this.y + this.ry, this.y - this.ry};
        shp.setXpts(xpts);
        shp.setYpts(ypts);
    }

    public void applySymmetryToShape(Shape shp) {
        shp.setSymmetry(1);
    }
}

