/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import org.catacomb.be.Position;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.drawing.ShapePoint;
import org.catacomb.report.E;

public class ShapeSymmetry {
    public static final int NONE = 0;
    public static final int RECTANGLE = 1;
    public static final int DIAMOND = 2;
    public static final int SQUARE = 3;
    public static final String[] symmetryNames = new String[]{"none", "rectangle", "diamond", "square"};

    public static String[] getSymmetryNames() {
        return symmetryNames;
    }

    public static void applySymmetry(Shape shape, ShapePoint sp, Position pos) {
        int isym = shape.getSymmetry();
        if (isym == 0) {
            sp.setPosition(pos);
        } else {
            ShapePoint[] spa = shape.getPoints();
            int isp = -1;
            int np = 4;
            int i = 0;
            while (i < np) {
                if (sp == spa[i]) {
                    isp = i;
                }
                ++i;
            }
            ShapePoint adjc = spa[(isp + 1) % np];
            ShapePoint opp = spa[(isp + 2) % np];
            ShapePoint adja = spa[(isp + 3) % np];
            double ox = opp.getPosition().getX();
            double oy = opp.getPosition().getY();
            double dx = pos.getX() - ox;
            double dy = pos.getY() - oy;
            double zx = dx;
            double zy = dy;
            if (isym == 3) {
                double z = Math.sqrt(0.5 * (dx * dx + dy * dy));
                zx = dx > 0.0 ? z : -z;
                zy = dy > 0.0 ? z : -z;
            } else if (isym != 1) {
                E.missing("sym=" + isym);
            }
            adjc.setPosition(new Position(ox + zx, oy));
            adja.setPosition(new Position(ox, oy + zy));
            sp.setPosition(new Position(ox + zx, oy + zy));
        }
    }

    public static String getStringSymmetry(int isym) {
        return symmetryNames[isym];
    }
}

