/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.catacomb.report.E;

public class Iconizer {
    public static void main(String[] argv) {
        File fin = new File(argv[0]);
        int dim = Integer.parseInt(argv[1]);
        int r = Integer.parseInt(argv[2]);
        int g = Integer.parseInt(argv[3]);
        int b = Integer.parseInt(argv[4]);
        File fout = new File(argv[5]);
        double[][] xy = Iconizer.readPerimiter(Iconizer.readStringFromFile(fin));
        Color cgray = new Color(140, 140, 140);
        BufferedImage bim = Iconizer.filledPolygonImage(xy[0], xy[1], dim, cgray, 0.02, 0.04, 2.5);
        BufferedImage bimc = Iconizer.filledPolygonImage(xy[0], xy[1], dim, new Color(r, g, b), 0.0, 0.0, 1.5);
        bim.getGraphics().drawImage(bimc, 0, 0, null);
        try {
            ImageIO.write((RenderedImage)bim, "png", fout);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static BufferedImage filledPolygonImage(double[] xp, double[] yp, int dim, Color col, double osx, double osy, double elf) {
        BufferedImage transim = new BufferedImage(dim, dim, 2);
        WritableRaster alpha = transim.getAlphaRaster();
        WritableRaster raster = transim.getRaster();
        double[][] d = Iconizer.alphaPixelize(xp, yp, dim, osx, osy, elf);
        int w = dim;
        int h = dim;
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        int[] itrans = new int[]{0};
        int[] ipxin = new int[4];
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                if (d[i][j] > 0.0) {
                    ipxin[0] = r;
                    ipxin[1] = g;
                    ipxin[2] = b;
                    raster.setPixel(i, j, ipxin);
                }
                itrans[0] = (int)(255.0 * d[i][j]);
                alpha.setPixel(i, j, itrans);
                ++j;
            }
            ++i;
        }
        return transim;
    }

    public static double[][] alphaPixelize(double[] xp0, double[] yp0, int dim, double osx, double osy, double elf) {
        double[][] ret = new double[dim][dim];
        double[] xp = Iconizer.rerange(xp0);
        double[] yp = Iconizer.rerange(yp0);
        double dx = 1.0 / (double)dim;
        double dy = 1.0 / (double)dim;
        int nsamp = 10;
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                double x0 = ((double)i + 0.5) * dx;
                double y0 = ((double)j + 0.5) * dy;
                ret[i][j] = Iconizer.coverage(xp, yp, x0 - osx, y0 - osy, elf * dx, elf * dy, nsamp);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private static double coverage(double[] xp, double[] yp, double xc0, double yc0, double dx0, double dy0, int nsamp) {
        int nin = 0;
        double x0 = xc0 - 0.5 * dx0;
        double y0 = yc0 - 0.5 * dy0;
        double dx = dx0 / (double)nsamp;
        double dy = dy0 / (double)nsamp;
        int i = 0;
        while (i < nsamp) {
            int j = 0;
            while (j < nsamp) {
                double x = x0 + ((double)i + 0.5) * dx;
                double y = y0 + ((double)i + 0.5) * dy;
                if (Iconizer.pointIsInside(x, y, xp, yp)) {
                    ++nin;
                }
                ++j;
            }
            ++i;
        }
        return 1.0 * (double)nin / (double)(nsamp * nsamp);
    }

    private static double[] rerange(double[] ap0) {
        double amin = ap0[0];
        double amax = ap0[0];
        int i = 0;
        while (i < ap0.length) {
            if (ap0[i] < amin) {
                amin = ap0[i];
            }
            if (ap0[i] > amax) {
                amax = ap0[i];
            }
            ++i;
        }
        amin -= 0.1 * (amax - amin);
        amax += 0.1 * (amax - amin);
        double[] ap = new double[ap0.length];
        int i2 = 0;
        while (i2 < ap0.length) {
            ap[i2] = (ap0[i2] - amin) / (amax - amin);
            ++i2;
        }
        return ap;
    }

    private static boolean pointIsInside(double x, double y, double[] xb, double[] yb) {
        int n = xb.length;
        int iwn = 0;
        int i = 0;
        while (i < n) {
            int idir = 0;
            int p = (i + 1) % n;
            if (yb[i] <= y && yb[p] > y) {
                idir = 1;
            }
            if (yb[i] > y && yb[p] <= y) {
                idir = -1;
            }
            if (idir != 0) {
                double f = (y - yb[i]) / (yb[p] - yb[i]);
                double xc = f * xb[p] + (1.0 - f) * xb[i];
                int isid = xc > x ? 1 : -1;
                iwn += isid * idir;
            }
            ++i;
        }
        return iwn != 0;
    }

    private static double[][] readPerimiter(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n\t ,");
        int n = st.countTokens() / 2;
        double[][] sy = new double[2][n];
        int i = 0;
        while (i < n) {
            sy[0][i] = new Double(st.nextToken());
            sy[1][i] = new Double(st.nextToken());
            ++i;
        }
        return sy;
    }

    public static String readStringFromFile(File f) {
        String sdat = "";
        try {
            FileInputStream ins = new FileInputStream(f);
            InputStreamReader insr = new InputStreamReader(ins);
            BufferedReader fr = new BufferedReader(insr);
            StringBuffer sb = new StringBuffer();
            while (fr.ready()) {
                sb.append(fr.readLine());
                sb.append("\n");
            }
            fr.close();
            sdat = sb.toString();
        }
        catch (IOException ex) {
            E.error("file read error ");
            ex.printStackTrace();
        }
        return sdat;
    }
}

