/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.catacomb.graph.gui.MouseHandler;
import org.catacomb.graph.gui.WorldCanvas;
import org.catacomb.interlish.interact.ClickListener;
import org.catacomb.report.E;
import org.catacomb.util.MouseUtil;

public final class Mouse
implements MouseListener,
MouseMotionListener {
    public static final int LEFT = 1;
    public static final int MIDDLE = 2;
    public static final int RIGHT = 3;
    private int button;
    private int canvasWidth;
    private int canvasHeight;
    private int xDown;
    private int yDown;
    private int xCurrent;
    private int yCurrent;
    private boolean down;
    private int nHandler;
    private MouseHandler[] handlers;
    private MouseHandler activeHandler;
    private MouseHandler motionHandler;
    private WorldCanvas canvas;
    private ClickListener clickListener;

    public Mouse(WorldCanvas c, boolean interactive) {
        this.canvas = c;
        if (interactive) {
            this.canvas.addMouseListener(this);
            this.canvas.addMouseMotionListener(this);
        }
        this.handlers = new MouseHandler[10];
    }

    public void setClickListener(ClickListener cl) {
        this.clickListener = cl;
    }

    public void detach() {
        this.canvas.removeMouseListener(this);
        this.canvas.removeMouseMotionListener(this);
    }

    public void addHandler(MouseHandler h) {
        if (this.nHandler >= this.handlers.length) {
            E.error("Mouse handler array too small");
        } else {
            this.handlers[this.nHandler++] = h;
        }
    }

    public void prependHandler(MouseHandler h) {
        if (this.nHandler >= this.handlers.length) {
            E.error("Mouse handler array too small");
        } else {
            int i = this.nHandler;
            while (i > 0) {
                this.handlers[i] = this.handlers[i - 1];
                --i;
            }
            this.handlers[0] = h;
            ++this.nHandler;
        }
    }

    private void requestRepaint() {
        this.canvas.repaint();
    }

    boolean leftButton() {
        return this.button == 1;
    }

    boolean middleButton() {
        return this.button == 2;
    }

    boolean rightButton() {
        return this.button == 3;
    }

    public void updateCanvasDimensions() {
        this.canvasWidth = this.canvas.getWidth();
        this.canvasHeight = this.canvas.getHeight();
    }

    int getCanvasWidth() {
        return this.canvasWidth;
    }

    int getCanvasHeight() {
        return this.canvasHeight;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.readPosition(e);
        if (this.clickListener != null) {
            this.clickListener.pointClicked(e.getX(), e.getY(), MouseUtil.getButton(e));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.down) {
            E.shortWarning("mouse moved when down?? " + e);
            this.down = false;
            return;
        }
        this.readPosition(e);
        int i = 0;
        while (i < this.nHandler) {
            MouseHandler mh = this.handlers[i];
            if (mh.isActive() && mh.motionAware() && mh.motionChange(this)) {
                this.motionHandler = mh;
                this.canvas.repaint();
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.down = true;
        this.motionHandler = null;
        this.readButton(e);
        this.readPosition(e);
        this.readPressPosition(e);
        this.activeHandler = null;
        int i = 0;
        while (i < this.nHandler) {
            MouseHandler mh = this.handlers[i];
            if (mh.isActive()) {
                mh.setClaimUndecided();
                mh.init(this);
                if (mh.isIn()) {
                    this.activeHandler = mh;
                    break;
                }
            }
            ++i;
        }
        if (this.activeHandler != null) {
            this.activeHandler.applyOnDown(this);
        }
        MouseHandler[] mouseHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            MouseHandler mh = mouseHandlerArray[n2];
            if (mh != this.activeHandler && mh != null) {
                mh.missedPress(this);
            }
            ++n2;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.down) {
            return;
        }
        this.readPosition(e);
        if (this.activeHandler == null) {
            int i = 0;
            while (i < this.nHandler) {
                MouseHandler mh = this.handlers[i];
                if (mh.isActive() && !mh.isOut()) {
                    mh.advance(this);
                    if (mh.isIn()) {
                        this.activeHandler = mh;
                        break;
                    }
                }
                ++i;
            }
        }
        if (this.activeHandler != null) {
            this.activeHandler.applyOnDrag(this);
            if (this.activeHandler.getRepaintStatus() == 2) {
                this.requestRepaint();
            } else if (this.activeHandler.getRepaintStatus() == 1) {
                this.requestRepaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.down) {
            return;
        }
        this.readPosition(e);
        if (this.activeHandler == null) {
            int i = 0;
            while (i < this.nHandler) {
                MouseHandler mh = this.handlers[i];
                if (mh.isActive() && !mh.isOut()) {
                    mh.release(this);
                    if (mh.isIn()) {
                        this.activeHandler = mh;
                        break;
                    }
                }
                ++i;
            }
        }
        if (this.activeHandler != null) {
            this.activeHandler.applyOnRelease(this);
        }
        this.activeHandler = null;
        this.down = false;
        this.requestRepaint();
        this.canvas.fixRanges();
        this.updateCanvasDimensions();
    }

    private void readPosition(MouseEvent e) {
        this.xCurrent = e.getX();
        this.yCurrent = e.getY();
    }

    private void readPressPosition(MouseEvent e) {
        this.xDown = e.getX();
        this.yDown = e.getY();
    }

    private void readButton(MouseEvent e) {
        this.button = MouseUtil.getButton(e);
    }

    public int getButton() {
        return this.button;
    }

    public boolean isDown() {
        return this.down;
    }

    int getX() {
        return this.xCurrent;
    }

    int getY() {
        return this.yCurrent;
    }

    int getXDown() {
        return this.xDown;
    }

    int getYDown() {
        return this.yDown;
    }

    void echoPaint(Graphics2D g) {
        if (this.activeHandler != null) {
            this.activeHandler.echoPaint(g);
            this.activeHandler.setRepaintStatus(0);
        } else if (this.motionHandler != null) {
            this.motionHandler.echoPaint(g);
        }
    }

    void boxSelected(int x0, int y0, int x1, int y1) {
        this.canvas.boxSelected(x0, y0, x1, y1);
    }

    void initializeZoom(int xc, int yc) {
        this.canvas.initializeZoom(xc, yc);
    }

    void dragZoom(double fx, double fy, int xc, int yc) {
        this.canvas.dragZoom(fx, fy, xc, yc);
    }

    void zoom(double fac, int xc, int yc) {
        this.canvas.zoom(fac, xc, yc);
    }

    void zoom(double xfac, double yfac, int xc, int yc) {
        this.canvas.zoom(xfac, yfac, xc, yc);
    }

    void trialPan(int xfrom, int yfrom, int xto, int yto) {
        this.canvas.trialPan(xfrom, yfrom, xto, yto);
    }

    void permanentPan(int xfrom, int yfrom, int xto, int yto) {
        this.canvas.permanentPan(xfrom, yfrom, xto, yto);
    }

    public void dragRollRotate(int pdx, int pdy) {
        this.canvas.dragRollRotate(pdx, pdy);
    }

    public void dragZRotate(int pdx, int pdy) {
        this.canvas.dragZRotate(pdx, pdy);
    }

    public void initializeRotation(int ix, int iy) {
        this.canvas.initializeRotation(ix, iy);
    }

    public void initializeRotation(double x, double y, double z) {
        this.canvas.initializeRotation(x, y, z);
    }

    public void restoreAA() {
        this.canvas.restoreAA();
    }
}

