/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import org.catacomb.datalish.Box;
import org.catacomb.graph.gui.BuildPaintInstructor;
import org.catacomb.graph.gui.Builder;
import org.catacomb.graph.gui.GridPainter;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.PickHandler;
import org.catacomb.graph.gui.PickListener;
import org.catacomb.graph.gui.PickStore;
import org.catacomb.graph.gui.WorldCanvas;
import org.catacomb.report.E;

public class PickWorldCanvas
extends WorldCanvas {
    static final long serialVersionUID = 1001L;
    PickStore pickStore = new PickStore();
    Builder builder = new Builder(this.getPainter(), this.pickStore);
    PickHandler pickHandler = new PickHandler(this.pickStore, this.getWorldTransform());
    BuildPaintInstructor buildPaintInstructor;
    GridPainter gridPainter;
    boolean drawGrid = true;

    public PickWorldCanvas(int w, int h, boolean interact) {
        super(w, h, interact);
        this.prependHandler(this.pickHandler);
        this.gridPainter = new GridPainter();
    }

    public void setXAxisLabel(String s) {
        this.gridPainter.setXAxisLabel(s);
    }

    @Override
    public void setBg(Color c) {
        super.setBg(c);
        if (this.gridPainter != null) {
            this.gridPainter.setGridBackground(c);
        }
    }

    public void setNoGrid() {
        this.gridPainter = null;
    }

    public void setShowGrid(boolean b) {
        this.drawGrid = b;
    }

    public void setBuildPaintInstructor(BuildPaintInstructor pi) {
        this.buildPaintInstructor = pi;
        if (pi instanceof PickListener) {
            this.setPickListener((PickListener)((Object)pi));
        }
    }

    public void setPickListener(PickListener pl) {
        this.pickHandler.setPickListener(pl);
    }

    public void setGridColor(Color c) {
        if (this.gridPainter != null) {
            this.gridPainter.setGridColor(c);
        }
    }

    public void setAxisColor(Color c) {
        if (this.gridPainter != null) {
            this.gridPainter.setAxisColor(c);
        }
    }

    @Override
    public void prePaint(Graphics2D g) {
        this.builder.clear();
        this.builder.setCanvasSize(this.getWidth(), this.getHeight());
        if (this.drawGrid && this.gridPainter != null) {
            this.gridPainter.paint(this.painter);
        }
    }

    @Override
    public void postPaint(Graphics2D g) {
        if (!this.mouse.isDown()) {
            this.pickHandler.echoPaint(this.painter, this.showTooltips());
        }
    }

    @Override
    public void paint2D(Graphics2D g) {
        this.applyAAPreference(g);
        if (this.buildPaintInstructor != null) {
            this.buildPaintInstructor.instruct(this.painter, this.builder);
        } else if (this.paintInstructor != null) {
            this.paintInstructor.instruct(this.painter);
        }
    }

    public void attach(Object obj) {
        boolean done = false;
        if (obj instanceof BuildPaintInstructor) {
            this.setBuildPaintInstructor((BuildPaintInstructor)obj);
            done = true;
        } else if (obj instanceof PaintInstructor) {
            this.setPaintInstructor((PaintInstructor)obj);
            done = true;
        }
        if (obj instanceof PickListener) {
            this.setPickListener((PickListener)obj);
            done = true;
        }
        if (!done) {
            E.error(" - cant attach " + obj + " to a PickWorldCanvas");
        }
    }

    public void setOnGridAxes() {
        this.gridPainter.setOnGridAxes();
    }

    @Override
    public void reframe() {
        if (this.buildPaintInstructor != null) {
            Box box = this.buildPaintInstructor.getLimitBox(this.painter);
            this.frameToBox(box);
        } else if (this.paintInstructor != null) {
            Box box = this.paintInstructor.getLimitBox();
            this.frameToBox(box);
        } else {
            E.shortWarning("no paint instructor?");
        }
    }
}

